/*
 * Decompiled with CFR 0.152.
 */
package com.spt.development.cid.web.spring.boot.autoconfigure;

import com.spt.development.cid.web.filter.CorrelationIdFilter;
import com.spt.development.cid.web.filter.MdcCorrelationIdFilter;
import com.spt.development.cid.web.spring.boot.autoconfigure.CidWebProperties;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={WebMvcAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={Servlet.class})
@EnableConfigurationProperties(value={CidWebProperties.class})
public class CidWebSpringAutoConfiguration {
    static final List<String> DEFAULT_URL_PATTERNS = Collections.singletonList("/*");
    private final CidWebProperties cidWebProperties;

    public CidWebSpringAutoConfiguration(CidWebProperties cidWebProperties) {
        this.cidWebProperties = cidWebProperties;
    }

    @Bean
    public FilterRegistrationBean<CorrelationIdFilter> correlationIdFilter() {
        FilterRegistrationBean filterRegBean = new FilterRegistrationBean((Filter)new CorrelationIdFilter(Optional.ofNullable(this.cidWebProperties.getCidHeader()).orElse("X-Correlation-ID"), Optional.ofNullable(this.cidWebProperties.getUseRequestHeader()).orElse(false).booleanValue()), new ServletRegistrationBean[0]);
        if (this.cidWebProperties.getBean().getName() != null) {
            filterRegBean.setName(this.cidWebProperties.getBean().getName());
        }
        filterRegBean.setOrder(Optional.ofNullable(this.cidWebProperties.getBean().getOrder()).orElse(Integer.MIN_VALUE).intValue());
        filterRegBean.setUrlPatterns(this.cidWebProperties.getBean().getUrlPatterns().isEmpty() ? DEFAULT_URL_PATTERNS : this.cidWebProperties.getBean().getUrlPatterns());
        return filterRegBean;
    }

    @Bean
    @ConditionalOnProperty(name={"spt.cid.mdc.disabled"}, havingValue="false", matchIfMissing=true)
    public FilterRegistrationBean<MdcCorrelationIdFilter> mdcCorrelationIdFilter(@Value(value="${spt.cid.mdc.cid-key:#{null}}") String mdcCidKey) {
        FilterRegistrationBean filterRegBean = new FilterRegistrationBean((Filter)new MdcCorrelationIdFilter(Optional.ofNullable(mdcCidKey).orElse("cid")), new ServletRegistrationBean[0]);
        CidWebProperties.RegistrationBean mdcFilterRegBeanProperties = this.cidWebProperties.getMdc().getBean();
        if (mdcFilterRegBeanProperties.getName() != null) {
            filterRegBean.setName(mdcFilterRegBeanProperties.getName());
        }
        filterRegBean.setOrder(Optional.ofNullable(mdcFilterRegBeanProperties.getOrder()).orElse(Optional.ofNullable(this.cidWebProperties.getBean().getOrder()).orElse(Integer.MIN_VALUE) + 1).intValue());
        filterRegBean.setUrlPatterns(mdcFilterRegBeanProperties.getUrlPatterns().isEmpty() ? DEFAULT_URL_PATTERNS : mdcFilterRegBeanProperties.getUrlPatterns());
        return filterRegBean;
    }
}

