/*
 * Decompiled with CFR 0.152.
 */
package com.spt.development.logging.spring.boot.autoconfigure;

import com.spt.development.logging.spring.DaoSupportLogger;
import com.spt.development.logging.spring.JmsListenerLogger;
import com.spt.development.logging.spring.RepositoryLogger;
import com.spt.development.logging.spring.RestControllerLogger;
import com.spt.development.logging.spring.ServiceLogger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.dao.support.DaoSupport;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.web.bind.annotation.RestController;

@AutoConfiguration
public class LoggingSpringAutoConfiguration {
    private final boolean mdcDisabled;

    public LoggingSpringAutoConfiguration(@Value(value="${spt.cid.mdc.disabled:false}") boolean mdcDisabled) {
        this.mdcDisabled = mdcDisabled;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={RestController.class})
    public RestControllerLogger restControllerLogger() {
        return new RestControllerLogger(this.mdcDisabled);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={JmsListener.class})
    public JmsListenerLogger jmsListenerLogger() {
        return new JmsListenerLogger(this.mdcDisabled);
    }

    @Bean
    @ConditionalOnMissingBean
    public ServiceLogger serviceLogger() {
        return new ServiceLogger(this.mdcDisabled);
    }

    @Bean
    @ConditionalOnMissingBean
    public RepositoryLogger repositoryLogger() {
        return new RepositoryLogger(this.mdcDisabled);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={DaoSupport.class})
    @ConditionalOnProperty(value={"spt.logging.dao-support.enabled"}, havingValue="true")
    public DaoSupportLogger daoSupportLogger() {
        return new DaoSupportLogger(this.mdcDisabled);
    }
}

