/*
 * Decompiled with CFR 0.152.
 */
package com.spt.development.logging.spring;

import com.spt.development.cid.CorrelationId;
import com.spt.development.logging.spring.LoggerUtil;
import com.spt.development.logging.spring.invocation.LoggedInvocation;
import java.lang.reflect.Method;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

abstract class InvocationLogger {
    private final boolean includeCorrelationIdInLogs;
    private final boolean isStartAndCompleteMethodLoggedAtInfo;

    InvocationLogger(boolean includeCorrelationIdInLogs) {
        this(includeCorrelationIdInLogs, false);
    }

    InvocationLogger(boolean includeCorrelationIdInLogs, boolean isStartAndCompleteMethodLoggedAtInfo) {
        this.includeCorrelationIdInLogs = includeCorrelationIdInLogs;
        this.isStartAndCompleteMethodLoggedAtInfo = isStartAndCompleteMethodLoggedAtInfo;
    }

    Object log(LoggedInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Logger log = LoggerFactory.getLogger(invocation.getDeclaringClass());
        if (log.isEnabledForLevel(this.isStartAndCompleteMethodLoggedAtInfo ? Level.INFO : Level.DEBUG)) {
            this.startAndCompleteMethodLogger().accept(log, "{}.{}({})", invocation.getDeclaringClass().getSimpleName(), method.getName(), LoggerUtil.formatArgs(method.getParameterAnnotations(), invocation.getArgs()));
        }
        return this.proceed(invocation, log);
    }

    Object proceed(LoggedInvocation invocation, Logger log) throws Throwable {
        Method method;
        Object result = invocation.proceed();
        if (log.isTraceEnabled() && !(method = invocation.getMethod()).getReturnType().equals(Void.TYPE)) {
            this.trace(log, "{}.{} Returned: {}", invocation.getDeclaringClass().getSimpleName(), method.getName(), result);
            return result;
        }
        this.startAndCompleteMethodLogger().accept(log, "{}.{} - complete", invocation.getDeclaringClass().getSimpleName(), invocation.getMethod().getName());
        return result;
    }

    private LoggerConsumer startAndCompleteMethodLogger() {
        return this.isStartAndCompleteMethodLoggedAtInfo ? this::info : this::debug;
    }

    void trace(Logger logger, String format, Object ... arguments) {
        this.log((arg_0, arg_1) -> ((Logger)logger).trace(arg_0, arg_1), format, arguments);
    }

    void debug(Logger logger, String format, Object ... arguments) {
        this.log((arg_0, arg_1) -> ((Logger)logger).debug(arg_0, arg_1), format, arguments);
    }

    void info(Logger logger, String format, Object ... arguments) {
        this.log((arg_0, arg_1) -> ((Logger)logger).info(arg_0, arg_1), format, arguments);
    }

    void error(Logger logger, String format, Object ... arguments) {
        this.log((arg_0, arg_1) -> ((Logger)logger).error(arg_0, arg_1), format, arguments);
    }

    private void log(BiConsumer<String, Object[]> log, String format, Object[] arguments) {
        if (this.includeCorrelationIdInLogs) {
            log.accept("[{}] " + format, this.addCorrelationIdToArguments(arguments));
            return;
        }
        log.accept(format, arguments);
    }

    private Object[] addCorrelationIdToArguments(Object[] arguments) {
        Object[] newArguments = new Object[arguments.length + 1];
        newArguments[0] = CorrelationId.get();
        System.arraycopy(arguments, 0, newArguments, 1, arguments.length);
        return newArguments;
    }

    @FunctionalInterface
    public static interface LoggerConsumer {
        public void accept(Logger var1, String var2, Object ... var3);
    }
}

