/*
 * Decompiled with CFR 0.152.
 */
package com.spt.development.logging.spring;

import com.spt.development.logging.spring.LoggerAspect;
import com.spt.development.logging.spring.invocation.LoggedInvocation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=1)
public class JmsListenerLogger
extends LoggerAspect {
    public JmsListenerLogger() {
        this(true);
    }

    public JmsListenerLogger(boolean includeCorrelationIdInLogs) {
        super(includeCorrelationIdInLogs, true);
    }

    @Override
    @Around(value="@annotation(org.springframework.jms.annotation.JmsListener) && !loggingDisabled()")
    public Object log(ProceedingJoinPoint point) throws Throwable {
        return super.log(point);
    }

    @Override
    Object proceed(LoggedInvocation invocation, Logger log) throws Throwable {
        Object result = invocation.proceed();
        this.info(log, "{}.{} - complete", invocation.getDeclaringClass().getSimpleName(), invocation.getMethod().getName());
        return result;
    }
}

