/*
 * Decompiled with CFR 0.152.
 */
package com.spt.development.logging.spring;

import com.spt.development.logging.spring.LoggerAspect;
import com.spt.development.logging.spring.invocation.LoggedInvocation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.client.HttpStatusCodeException;

@Aspect
public class RestControllerLogger
extends LoggerAspect {
    private static final String HTTP_STATUS_FIELD = "code";

    public RestControllerLogger() {
        this(true);
    }

    public RestControllerLogger(boolean includeCorrelationIdInLogs) {
        super(includeCorrelationIdInLogs, true);
    }

    @Override
    @Around(value="@within(org.springframework.web.bind.annotation.RestController) && !loggingDisabled()")
    public Object log(ProceedingJoinPoint point) throws Throwable {
        return super.log(point);
    }

    @Override
    Object proceed(LoggedInvocation invocation, Logger log) throws Throwable {
        try {
            return super.proceed(invocation, log);
        }
        catch (Throwable t) {
            if (this.isUnexpectedOr5xxServerError(t)) {
                this.error(log, "{}.{} threw exception: ", invocation.getDeclaringClass().getSimpleName(), invocation.getMethod().getName(), t);
            } else {
                this.info(log, "{}.{} threw exception: {}", invocation.getDeclaringClass().getSimpleName(), invocation.getMethod().getName(), t.getClass().getCanonicalName());
                this.debug(log, "Exception: ", t);
            }
            throw t;
        }
    }

    private boolean isUnexpectedOr5xxServerError(Throwable t) {
        if (!(t instanceof HttpStatusCodeException)) {
            AnnotationAttributes responseStatus = AnnotatedElementUtils.getMergedAnnotationAttributes(t.getClass(), ResponseStatus.class);
            return responseStatus == null || !responseStatus.containsKey((Object)HTTP_STATUS_FIELD) || ((HttpStatus)responseStatus.getEnum(HTTP_STATUS_FIELD)).is5xxServerError();
        }
        return ((HttpStatusCodeException)t).getStatusCode().is5xxServerError();
    }
}

