/*
 * Decompiled with CFR 0.152.
 */
package com.spt.development.logging.spring.annotation;

import com.spt.development.logging.spring.BeanLogger;
import com.spt.development.logging.spring.annotation.EnableBeanLogging;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.CollectionUtils;

@Role(value=2)
@EnableAspectJAutoProxy
@Configuration(proxyBeanMethods=false)
public class BeanLoggerConfiguration
implements ImportAware {
    private Set<Class<?>> includeBasePackageClasses = Collections.emptySet();
    private Set<Class<?>> excludedClasses = Collections.emptySet();

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableBeanLogging.class.getName(), false));
        if (attributes != null) {
            this.includeBasePackageClasses = new HashSet<Class>(Arrays.asList(attributes.getClassArray("includeBasePackageClasses")));
            if (CollectionUtils.isEmpty(this.includeBasePackageClasses)) {
                throw new IllegalStateException("Property 'includeBasePackageClasses' must contain at least one class, when enabling bean logging with @EnableBeanLogger annotation");
            }
            this.excludedClasses = new HashSet<Class>(Arrays.asList(attributes.getClassArray("excludedClasses")));
        }
    }

    @Bean
    @Role(value=2)
    public AspectJExpressionPointcutAdvisor beanLogger(@Value(value="${spt.cid.mdc.disabled:false}") boolean mdcDisabled) {
        AspectJExpressionPointcutAdvisor pointcutAdvisor = new AspectJExpressionPointcutAdvisor();
        pointcutAdvisor.setExpression(this.buildPointcutAdvisorExpression());
        pointcutAdvisor.setAdvice((Advice)new BeanLogger(mdcDisabled));
        return pointcutAdvisor;
    }

    private String buildPointcutAdvisorExpression() {
        StringBuilder sb = new StringBuilder("(");
        for (Class<?> includeBasePackage : this.includeBasePackageClasses) {
            if (sb.length() > 1) {
                sb.append(" || ");
            }
            sb.append("execution(* ").append(includeBasePackage.getPackageName()).append("..*(..))");
        }
        sb.append(')');
        for (Class<?> excludedClass : this.excludedClasses) {
            sb.append(" && !execution(* ").append(excludedClass.getName()).append("..*(..))");
        }
        sb.append(" && !(").append("@annotation(com.spt.development.logging.NoLogging) || @target(com.spt.development.logging.NoLogging)").append(')');
        return sb.toString();
    }
}

