/*
 * Decompiled with CFR 0.152.
 */
package com.spt.development.test;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;

public final class LogbackUtil {
    private LogbackUtil() {
    }

    public static <T> T verifyInfoLogging(Class<?> clazz, Callable<T> act, String ... expectedMessageParts) {
        return LogbackUtil.verifyLogging(clazz, act, Level.INFO, expectedMessageParts);
    }

    public static <T> T verifyWarnLogging(Class<?> clazz, Callable<T> act, String ... expectedMessageParts) {
        return LogbackUtil.verifyLogging(clazz, act, Level.WARN, expectedMessageParts);
    }

    public static <T> T verifyErrorLogging(Class<?> clazz, Callable<T> act, String ... expectedMessageParts) {
        return LogbackUtil.verifyLogging(clazz, act, Level.ERROR, expectedMessageParts);
    }

    public static <T> T verifyLogging(Class<?> clazz, Callable<T> act, Level level, String ... expectedMessageParts) {
        return LogbackUtil.verifyLogging(clazz, act, logs -> {
            ILoggingEvent logEvent = logs.stream().filter(e -> e.getLevel() == level).findFirst().orElse(null);
            MatcherAssert.assertThat((Object)logEvent, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            for (String expectedLogPart : expectedMessageParts) {
                MatcherAssert.assertThat((Object)logEvent.getFormattedMessage(), (Matcher)CoreMatchers.containsString((String)expectedLogPart));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T verifyLogging(Class<?> clazz, Callable<T> act, Consumer<List<ILoggingEvent>> asserts) {
        Appender<ILoggingEvent> appender = LogbackUtil.createMockAppender();
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.getLogger(clazz).addAppender(appender);
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(ILoggingEvent.class);
        try {
            T result = act.call();
            ((Appender)Mockito.verify(appender, (VerificationMode)Mockito.atLeastOnce())).doAppend((Object)((ILoggingEvent)eventCaptor.capture()));
            asserts.accept(eventCaptor.getAllValues());
            T t = result;
            return t;
        }
        catch (Throwable t) {
            Object object = Assertions.fail((Throwable)t);
            return (T)object;
        }
        finally {
            loggerContext.getLogger(clazz).detachAppender(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T verifyNoLogging(Class<?> clazz, Callable<T> act) {
        Appender<ILoggingEvent> appender = LogbackUtil.createMockAppender();
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.getLogger(clazz).addAppender(appender);
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(ILoggingEvent.class);
        try {
            T result = act.call();
            ((Appender)Mockito.verify(appender, (VerificationMode)Mockito.never())).doAppend((Object)((ILoggingEvent)eventCaptor.capture()));
            T t = result;
            return t;
        }
        catch (Throwable t) {
            Object object = Assertions.fail((Throwable)t);
            return (T)object;
        }
        finally {
            loggerContext.getLogger(clazz).detachAppender(appender);
        }
    }

    private static Appender<ILoggingEvent> createMockAppender() {
        return (Appender)Mockito.mock(Appender.class);
    }
}

