/*
 * Decompiled with CFR 0.152.
 */
package com.spt.development.test.integration;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIBuilder;

public class HttpTestManager {
    private static final String DEFAULT_SCHEME = "http";
    private static final String DEFAULT_HOST = "localhost";
    private final String scheme;
    private final String host;
    private int port;
    private int statusCode;
    private Header[] responseHeaders;
    private String responseBody;

    public HttpTestManager() {
        this(DEFAULT_SCHEME, DEFAULT_HOST);
    }

    public HttpTestManager(String scheme, String host) {
        this.scheme = scheme;
        this.host = host;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Header[] getResponseHeaders() {
        return Arrays.copyOf(this.responseHeaders, this.responseHeaders.length);
    }

    public Optional<String> getResponseHeaderValue(String name) {
        return Arrays.stream(this.responseHeaders).filter(h -> name.equals(h.getName())).map(NameValuePair::getValue).findFirst();
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public void init(int port) {
        this.port = port;
        this.statusCode = 0;
        this.responseHeaders = null;
        this.responseBody = null;
    }

    public void doPostRequest(String resource, ContentType contentType, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        try (InputStream is = this.getClass().getResourceAsStream(resource);){
            this.doPostRequest(is, contentType, path, parameters);
        }
    }

    public void doPostRequest(InputStream is, ContentType contentType, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        this.doPostRequest(null, (HttpEntity)new InputStreamEntity(is, contentType), path, parameters);
    }

    public void doPostRequest(String username, String password, String resource, ContentType contentType, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        try (InputStream is = this.getClass().getResourceAsStream(resource);){
            this.doPostRequest(HttpTestManager.basicCredentialsProvider(username, password), is, contentType, path, parameters);
        }
    }

    public void doPostRequest(String username, String password, InputStream is, ContentType contentType, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        this.doPostRequest(HttpTestManager.basicCredentialsProvider(username, password), is, contentType, path, parameters);
    }

    public void doPostRequest(CredentialsProvider credentialsProvider, InputStream is, ContentType contentType, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        this.doPostRequest(credentialsProvider, (HttpEntity)new InputStreamEntity(is, contentType), path, parameters);
    }

    public void doPostRequest(HttpEntity httpEntity, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        this.doPostRequest(null, httpEntity, path, parameters);
    }

    public void doPostRequest(String username, String password, HttpEntity httpEntity, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        this.doPostRequest(HttpTestManager.basicCredentialsProvider(username, password), httpEntity, path, parameters);
    }

    public void doPostRequest(CredentialsProvider credentialsProvider, HttpEntity httpEntity, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        Function<URI, HttpUriRequestBase> requestFactory = uri -> {
            HttpPost request = new HttpPost(uri);
            request.setEntity(httpEntity);
            return request;
        };
        this.doRequest(credentialsProvider, requestFactory, path, parameters);
    }

    public void doPutRequest(String resource, ContentType contentType, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        try (InputStream is = this.getClass().getResourceAsStream(resource);){
            this.doPutRequest(is, contentType, path, parameters);
        }
    }

    public void doPutRequest(InputStream is, ContentType contentType, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        this.doPutRequest(null, (HttpEntity)new InputStreamEntity(is, contentType), path, parameters);
    }

    public void doPutRequest(String username, String password, String resource, ContentType contentType, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        try (InputStream is = this.getClass().getResourceAsStream(resource);){
            this.doPutRequest(HttpTestManager.basicCredentialsProvider(username, password), is, contentType, path, parameters);
        }
    }

    public void doPutRequest(String username, String password, InputStream is, ContentType contentType, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        this.doPutRequest(HttpTestManager.basicCredentialsProvider(username, password), is, contentType, path, parameters);
    }

    public void doPutRequest(CredentialsProvider credentialsProvider, InputStream is, ContentType contentType, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        this.doPutRequest(credentialsProvider, (HttpEntity)new InputStreamEntity(is, contentType), path, parameters);
    }

    public void doPutRequest(HttpEntity httpEntity, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        this.doPutRequest(null, httpEntity, path, parameters);
    }

    public void doPutRequest(String username, String password, HttpEntity httpEntity, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        this.doPutRequest(HttpTestManager.basicCredentialsProvider(username, password), httpEntity, path, parameters);
    }

    public void doPutRequest(CredentialsProvider credentialsProvider, HttpEntity httpEntity, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        Function<URI, HttpUriRequestBase> requestFactory = uri -> {
            HttpPut request = new HttpPut(uri);
            request.setEntity(httpEntity);
            return request;
        };
        this.doRequest(credentialsProvider, requestFactory, path, parameters);
    }

    public void doPatchRequest(String username, String password, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        this.doPatchRequest(HttpTestManager.basicCredentialsProvider(username, password), (HttpEntity)new StringEntity(""), path, parameters);
    }

    public void doPatchRequest(String username, String password, InputStream is, ContentType contentType, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        this.doPatchRequest(HttpTestManager.basicCredentialsProvider(username, password), is, contentType, path, parameters);
    }

    public void doPatchRequest(CredentialsProvider credentialsProvider, InputStream is, ContentType contentType, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        this.doPatchRequest(credentialsProvider, (HttpEntity)new InputStreamEntity(is, contentType), path, parameters);
    }

    public void doPatchRequest(HttpEntity httpEntity, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        this.doPatchRequest(null, httpEntity, path, parameters);
    }

    public void doPatchRequest(String username, String password, HttpEntity httpEntity, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        this.doPatchRequest(HttpTestManager.basicCredentialsProvider(username, password), httpEntity, path, parameters);
    }

    public void doPatchRequest(CredentialsProvider credentialsProvider, HttpEntity httpEntity, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        Function<URI, HttpUriRequestBase> requestFactory = uri -> {
            HttpPatch request = new HttpPatch(uri);
            request.setEntity(httpEntity);
            return request;
        };
        this.doRequest(credentialsProvider, requestFactory, path, parameters);
    }

    public void doGetRequest(String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        this.doRequest(null, HttpGet::new, path, parameters);
    }

    public void doGetRequest(String username, String password, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        this.doGetRequest(HttpTestManager.basicCredentialsProvider(username, password), path, parameters);
    }

    public void doGetRequest(CredentialsProvider credentialsProvider, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        this.doRequest(credentialsProvider, HttpGet::new, path, parameters);
    }

    public void doDeleteRequest(String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        this.doRequest(null, HttpDelete::new, path, parameters);
    }

    public void doDeleteRequest(String username, String password, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        this.doDeleteRequest(HttpTestManager.basicCredentialsProvider(username, password), path, parameters);
    }

    public static CredentialsProvider basicCredentialsProvider(String username, String password) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(null, -1), (Credentials)new UsernamePasswordCredentials(username, password.toCharArray()));
        return credentialsProvider;
    }

    public void doDeleteRequest(CredentialsProvider credentialsProvider, String path, NameValuePair ... parameters) throws IOException, URISyntaxException {
        this.doRequest(credentialsProvider, HttpDelete::new, path, parameters);
    }

    public void doRequest(CredentialsProvider credentialsProvider, Function<URI, HttpUriRequestBase> requestFactory, String path, NameValuePair ... parameters) throws URISyntaxException, IOException {
        HttpUriRequestBase request = requestFactory.apply(new URIBuilder().setScheme(this.scheme).setHost(this.host).setPort(this.port).setPath(path).setParameters(parameters).build());
        this.doRequest(credentialsProvider, request);
    }

    public void doRequest(CredentialsProvider credentialsProvider, HttpUriRequestBase request) throws IOException {
        try (CloseableHttpClient client = this.createHttpClient();){
            this.responseBody = (String)client.execute((ClassicHttpRequest)request, this.createHttpContext(credentialsProvider), response -> {
                this.statusCode = response.getCode();
                this.responseHeaders = response.getHeaders();
                if (response.getEntity() != null) {
                    return IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                }
                return null;
            });
        }
    }

    private CloseableHttpClient createHttpClient() {
        return HttpClients.custom().disableAutomaticRetries().build();
    }

    private HttpContext createHttpContext(CredentialsProvider credentialsProvider) {
        if (credentialsProvider != null) {
            HttpHost targetHost = new HttpHost(this.scheme, this.host, this.port);
            BasicScheme authScheme = new BasicScheme();
            authScheme.initPreemptive(credentialsProvider.getCredentials(new AuthScope(this.host, this.port), null));
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(targetHost, (AuthScheme)authScheme);
            HttpClientContext context = HttpClientContext.create();
            context.setCredentialsProvider(credentialsProvider);
            context.setAuthCache((AuthCache)authCache);
            return context;
        }
        return null;
    }
}

