/*
 * Decompiled with CFR 0.152.
 */
package com.spt.development.test.integration;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.converter.MessageConverter;

public class JmsTestManager {
    public static final int ASYNC_TEST_TIMEOUT_MS = 30000;
    private static final Logger LOG = LoggerFactory.getLogger(JmsTestManager.class);
    private final JmsTemplate jmsTemplate;

    public JmsTestManager(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public List<Object> consumeAllMessagesOnQueue(String queue) {
        return this.consumeAllMessagesOnQueue(queue, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> consumeAllMessagesOnQueue(String queue, boolean messagesExpected) {
        long originalTimeout = this.jmsTemplate.getReceiveTimeout();
        try {
            List<Object> list = this.doConsumeAllMessagesOnQueue(queue, messagesExpected);
            return list;
        }
        finally {
            this.jmsTemplate.setReceiveTimeout(originalTimeout);
        }
    }

    private List<Object> doConsumeAllMessagesOnQueue(String queue, boolean messagesExpected) {
        Object message = this.receiveAndConvert(queue, messagesExpected);
        if (message == null) {
            if (messagesExpected) {
                LOG.warn("Expected to find messages on the queue: '{}' when clearing it, but none were found", (Object)queue);
            }
            return Collections.emptyList();
        }
        return this.consumeRemainingMessages(queue, messagesExpected, message);
    }

    private List<Object> consumeRemainingMessages(String queue, boolean messagesExpected, Object firstMessage) {
        ArrayList<Object> messages = new ArrayList<Object>(Collections.singletonList(firstMessage));
        if (!messagesExpected) {
            LOG.warn("Found message with contents: {} on queue: '{}' when clearing it. This usually indicates a previous test failed", firstMessage, (Object)queue);
        }
        this.jmsTemplate.setReceiveTimeout(-1L);
        Message m = this.jmsTemplate.receive(queue);
        while (m != null) {
            messages.add(m);
            m = this.jmsTemplate.receive(queue);
        }
        return messages;
    }

    public Object receiveAndConvert(String queue) {
        return this.receiveAndConvert(queue, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object receiveAndConvert(String queue, boolean messagesExpected) {
        long originalTimeout = this.jmsTemplate.getReceiveTimeout();
        try {
            this.jmsTemplate.setReceiveTimeout(messagesExpected ? 30000L : -1L);
            if (messagesExpected) {
                LOG.info("Receiving message on queue: '{}'. Messages expected, so waiting up to {}ms for message", (Object)queue, (Object)30000);
            }
            Object object = this.doReceiveAndConvert(queue);
            return object;
        }
        finally {
            this.jmsTemplate.setReceiveTimeout(originalTimeout);
        }
    }

    private Object doReceiveAndConvert(String queue) {
        Message message = this.jmsTemplate.receive(queue);
        if (message != null) {
            LOG.debug("Received message: {} on queue: '{}'", (Object)message, (Object)queue);
            return this.doConvertFromMessage(message);
        }
        return null;
    }

    private Object doConvertFromMessage(Message message) {
        return Optional.ofNullable(this.jmsTemplate.getMessageConverter()).map(c -> this.fromMessage((MessageConverter)c, message)).orElseThrow(() -> new IllegalStateException("jmsTemplate must havd a message converter"));
    }

    private Object fromMessage(MessageConverter converter, Message message) {
        try {
            return converter.fromMessage(message);
        }
        catch (JMSException ex) {
            throw JmsUtils.convertJmsAccessException((JMSException)ex);
        }
    }
}

