/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.firebird.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.firebird.metadata.FirebirdUtils;
import com.sqlapp.data.db.metadata.ColumnReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.CheckConstraint;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class FirebirdColumnReader
extends ColumnReader {
    protected FirebirdColumnReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Column> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Column column = FirebirdColumnReader.this.createColumn(rs);
                result.add(column);
            }
        });
        return result;
    }

    protected Column createColumn(ExResultSet rs) throws SQLException {
        String tableName = CommonUtils.trim((String)this.getString((ResultSet)rs, "table_name"));
        String defaultSource = CommonUtils.trim((String)this.getString((ResultSet)rs, "DEFAULT_SOURCE"));
        Column obj = new Column(CommonUtils.trim((String)this.getString((ResultSet)rs, "column_name")));
        obj.setTableName(tableName);
        int segmentLength = rs.getInt("SEGMENT_LENGTH");
        int length = rs.getInt("FIELD_LENGTH");
        int precision = rs.getInt("FIELD_PRECISION");
        int scale = CommonUtils.abs((int)rs.getInt("FIELD_SCALE"));
        short nullFlag = rs.getShort("NULL_FLAG");
        int type = rs.getInt("FIELD_TYPE");
        int subType = rs.getInt("FIELD_SUB_TYPE");
        if (nullFlag == 1) {
            obj.setNullable(true);
        } else {
            obj.setNullable(false);
        }
        String checkCondition = this.getString((ResultSet)rs, "CHECK_CONDITION");
        String computed = CommonUtils.trim((String)this.getString((ResultSet)rs, "COMPUTED_SOURCE"));
        int lowerBound = rs.getInt("LOWER_BOUND");
        int upperBound = rs.getInt("UPPER_BOUND");
        if (upperBound > 0) {
            obj.setArrayDimension(1);
            obj.setArrayDimensionLowerBound(lowerBound);
            obj.setArrayDimensionUpperBound(upperBound);
        }
        obj.setFormula(computed);
        FirebirdUtils.setDefaultConstraint(obj, CommonUtils.trim((String)defaultSource));
        this.setCheckConstraint(obj, tableName, CommonUtils.trim((String)checkCondition));
        FirebirdUtils.setDbType(obj, type, subType, length, precision, scale, segmentLength);
        return obj;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("columns.sql");
    }

    private void setCheckConstraint(Column column, String tableName, String condition) {
        if (CommonUtils.isEmpty((CharSequence)condition)) {
            return;
        }
        String val = FirebirdUtils.convertCheckConstraint(condition);
        String replace = val.replaceAll("VALUE", column.getName());
        CheckConstraint constraint = new CheckConstraint("CHECK_" + tableName + column.getName(), replace, new Column[]{column});
        column.setCheckConstraint(constraint);
    }
}

