/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.firebird.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.ColumnPair;
import com.sqlapp.data.db.metadata.ForeignKeyConstraintReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.CascadeRule;
import com.sqlapp.data.schemas.Deferrability;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FlexList;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class FirebirdForeignKeyConstraintReader
extends ForeignKeyConstraintReader {
    public FirebirdForeignKeyConstraintReader(Dialect dialect) {
        super(dialect);
    }

    protected List<ForeignKeyConstraint> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List list = CommonUtils.list();
        final TripleKeyMap tCMap = CommonUtils.tripleKeyMap();
        final TripleKeyMap tColMap = CommonUtils.tripleKeyMap();
        final String pk_table_catalog = null;
        final String pk_table_schema = null;
        final String fk_table_catalog = null;
        final String fk_table_schema = null;
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String pk_table_name = CommonUtils.trim((String)this.getString(rs, "PKTABLE_NAME"));
                String pk_columnName = CommonUtils.trim((String)this.getString(rs, "PKCOLUMN_NAME"));
                String fk_table_name = CommonUtils.trim((String)this.getString(rs, "FKTABLE_NAME"));
                String fk_columnName = CommonUtils.trim((String)this.getString(rs, "FKCOLUMN_NAME"));
                String fk_name = CommonUtils.trim((String)this.getString(rs, "FK_NAME"));
                String pk_name = CommonUtils.trim((String)this.getString(rs, "PK_NAME"));
                ForeignKeyConstraint c = (ForeignKeyConstraint)tCMap.get((Object)pk_table_catalog, (Object)pk_table_schema, (Object)fk_name);
                FlexList colList = (FlexList)tColMap.get((Object)pk_table_catalog, (Object)pk_table_schema, (Object)fk_name);
                if (c == null) {
                    c = new ForeignKeyConstraint(fk_name);
                    c.setSchemaName(pk_table_schema);
                    c.setTableName(pk_table_name);
                    c.setUpdateRule(CascadeRule.parse((String)CommonUtils.trim((String)this.getString(rs, "UPDATE_RULE"))));
                    c.setDeleteRule(CascadeRule.parse((String)CommonUtils.trim((String)this.getString(rs, "DELETE_RULE"))));
                    c.setDeferrability(Deferrability.getDeferrability((!"NO".equalsIgnoreCase(CommonUtils.trim((String)this.getString(rs, "DEFERRABLE"))) ? 1 : 0) != 0, (!"NO".equalsIgnoreCase(CommonUtils.trim((String)this.getString(rs, "INITIALLY_DEFERRED"))) ? 1 : 0) != 0));
                    colList = new FlexList();
                    tCMap.put((Object)pk_table_catalog, (Object)pk_table_schema, (Object)fk_name, (Object)c);
                    tColMap.put((Object)pk_table_catalog, (Object)pk_table_schema, (Object)fk_name, (Object)colList);
                    list.add(c);
                }
                ColumnPair cPair = new ColumnPair();
                cPair.refCatalogName = fk_table_catalog;
                cPair.refSchemaName = fk_table_schema;
                cPair.refTableName = fk_table_name;
                cPair.refColumnName = fk_columnName;
                cPair.columnName = pk_columnName;
                colList.add((Object)cPair);
            }
        });
        this.setForeignKeyConstraintColumns(tColMap, list);
        return list;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("foreignKeyConstraints.sql");
    }
}

