/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.firebird.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.firebird.metadata.FirebirdUtils;
import com.sqlapp.data.db.metadata.ObjectPrivilegeReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ObjectPrivilege;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class FirebirdObjectPrivilegeReader
extends ObjectPrivilegeReader {
    protected FirebirdObjectPrivilegeReader(Dialect dialect) {
        super(dialect);
    }

    protected List<ObjectPrivilege> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                ObjectPrivilege obj = FirebirdObjectPrivilegeReader.this.createPrivilege(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("objectPrivileges.sql");
    }

    protected ObjectPrivilege createPrivilege(ExResultSet rs) throws SQLException {
        ObjectPrivilege obj = new ObjectPrivilege();
        obj.setObjectName(this.getString((ResultSet)rs, "object_name"));
        obj.setPrivilege(FirebirdUtils.getPrivilege(this.getString((ResultSet)rs, "privilege_type")));
        obj.setGrantorName(this.getString((ResultSet)rs, "grantor"));
        obj.setGranteeName(this.getString((ResultSet)rs, "grantee"));
        obj.setGrantable("1".equals(this.getString((ResultSet)rs, "is_grantable")));
        return obj;
    }
}

