/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.firebird.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.firebird.metadata.FirebirdUtils;
import com.sqlapp.data.db.metadata.RoutineArgumentReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.NamedArgument;
import com.sqlapp.data.schemas.Procedure;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Routine;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ParameterDirection;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class FirebirdProcedureArgumentReader
extends RoutineArgumentReader<Procedure> {
    protected FirebirdProcedureArgumentReader(Dialect dialect) {
        super(dialect);
    }

    protected List<NamedArgument> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                NamedArgument column = FirebirdProcedureArgumentReader.this.createNamedArgument(rs);
                result.add(column);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("procedureArguments.sql");
    }

    protected NamedArgument createNamedArgument(ExResultSet rs) throws SQLException {
        Procedure routine = new Procedure(this.getString((ResultSet)rs, "routine_name"));
        routine.setDialect(this.getDialect());
        NamedArgument obj = this.createObject(this.getString((ResultSet)rs, "parameter_name"));
        SchemaUtils.setRoutine((NamedArgument)obj, (Routine)routine);
        int segmentLength = rs.getInt("SEGMENT_LENGTH");
        int length = rs.getInt("FIELD_LENGTH");
        int precision = rs.getInt("FIELD_PRECISION");
        int scale = CommonUtils.abs((int)rs.getInt("FIELD_SCALE"));
        short nullFlag = rs.getShort("NULL_FLAG");
        int type = rs.getInt("FIELD_TYPE");
        int subType = rs.getInt("FIELD_SUB_TYPE");
        if (nullFlag == 1) {
            obj.setNullable(true);
        } else {
            obj.setNullable(false);
        }
        obj.setCharacterSet(this.getString((ResultSet)rs, "character_set_name"));
        obj.setCollation(this.getString((ResultSet)rs, "collation_name"));
        obj.setRemarks(this.getString((ResultSet)rs, "remarks"));
        int lowerBound = rs.getInt("LOWER_BOUND");
        int upperBound = rs.getInt("UPPER_BOUND");
        if (upperBound > 0) {
            obj.setArrayDimension(1);
            obj.setArrayDimensionLowerBound(lowerBound);
            obj.setArrayDimensionUpperBound(upperBound);
        }
        FirebirdUtils.setDbType(obj, type, subType, length, precision, scale, segmentLength);
        int direction = rs.getInt("PARAMETER_TYPE");
        if (direction == 0) {
            obj.setDirection(ParameterDirection.Input);
        } else if (direction == 1) {
            obj.setDirection(ParameterDirection.Output);
        } else if (direction == 2) {
            obj.setDirection(ParameterDirection.Inout);
        }
        return obj;
    }
}

