/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.firebird.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.SequenceReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Sequence;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SqlExecuter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class FirebirdSequenceReader
extends SequenceReader {
    protected FirebirdSequenceReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Sequence> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Sequence sequence = FirebirdSequenceReader.this.createSequence(rs);
                result.add(sequence);
            }
        });
        return result;
    }

    protected Sequence createSequence(ExResultSet rs) throws SQLException {
        String name = CommonUtils.trim((String)this.getString((ResultSet)rs, "RDB$GENERATOR_NAME"));
        Sequence sequence = new Sequence(name);
        sequence.setCycle(false);
        return sequence;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("sequences.sql");
    }

    protected void setMetadataDetail(Connection connection, Sequence sequence) throws SQLException {
        BigDecimal lastNumber = this.getCurrentNumber(connection, sequence.getName());
        sequence.setLastValue((Number)lastNumber);
    }

    protected BigDecimal getCurrentNumber(Connection connection, String sequenceName) {
        SqlExecuter sql = new SqlExecuter("SELECT GEN_ID(");
        sql.addSqlLine(sequenceName + ", 0) FROM RDB$DATABASE");
        return (BigDecimal)sql.executeScalar(connection, BigDecimal.class, 1);
    }
}

