/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.firebird.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.TableSpaceFileReader;
import com.sqlapp.data.db.metadata.TableSpaceReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.TableSpace;
import com.sqlapp.data.schemas.TableSpaceFile;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class FirebirdTableSpaceReader
extends TableSpaceReader {
    protected FirebirdTableSpaceReader(Dialect dialect) {
        super(dialect);
    }

    protected List<TableSpace> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String path = CommonUtils.trim((String)this.getString(rs, "MON$DATABASE_NAME"));
                String[] splitPaths = path.split("[/\\\\]");
                String lastPath = splitPaths[splitPaths.length - 1];
                String[] splitLastName = lastPath.split("[.]");
                String name = splitLastName[0];
                TableSpace storageSpace = new TableSpace(name);
                storageSpace.setCreatedAt(rs.getTimestamp("MON$CREATION_DATE"));
                TableSpaceFile storageFile = new TableSpaceFile(path, path);
                storageSpace.getTableSpaceFiles().add((AbstractNamedObject)storageFile);
                result.add(storageSpace);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("tableSpaces.sql");
    }

    protected TableSpaceFileReader newTableSpaceFileReader() {
        return null;
    }
}

