/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.firebird.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.TriggerReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Trigger;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FirebirdTriggerReader
extends TriggerReader {
    private static final Pattern STATEMENT_PATTERN = Pattern.compile("AS\\s+(.*)", 42);

    protected FirebirdTriggerReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Trigger> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String name = CommonUtils.trim((String)this.getString(rs, "RDB$TRIGGER_NAME"));
                int triggerType = rs.getInt("RDB$TRIGGER_TYPE");
                int inactive = rs.getInt("RDB$TRIGGER_INACTIVE");
                Trigger trigger = new Trigger(name);
                trigger.setTableName(CommonUtils.trim((String)this.getString(rs, "RDB$RELATION_NAME")));
                trigger.setActionTiming(FirebirdTriggerReader.this.getActionTimingString(triggerType));
                trigger.setEventManipulation(FirebirdTriggerReader.this.getEventManipulationString(triggerType));
                trigger.setActionOrientation("ROW");
                trigger.setEnable(0 == inactive);
                trigger.setActionReferenceOldRow("OLD");
                trigger.setActionReferenceNewRow("NEW");
                trigger.setStatement(FirebirdTriggerReader.this.getStatement(rs));
                FirebirdTriggerReader.this.setSpecifics(rs, "RDB$TRIGGER_SEQUENCE", "POSITION", (SpecificsProperty)trigger);
                result.add(trigger);
            }
        });
        return result;
    }

    private String getStatement(ExResultSet rs) throws SQLException {
        String statement = CommonUtils.trim((String)this.getString((ResultSet)rs, "RDB$TRIGGER_SOURCE"));
        Matcher mathcer = STATEMENT_PATTERN.matcher(statement);
        if (mathcer.matches()) {
            return mathcer.group(1);
        }
        return statement;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("triggers.sql");
    }

    private String getActionTimingString(int type) {
        if (type <= 0 || type >= 8000) {
            return "";
        }
        if (type % 2 == 0) {
            return "AFTER";
        }
        return "BEFORE";
    }

    private Set<String> getEventManipulationString(int type) {
        if (type <= 0) {
            return CommonUtils.set();
        }
        Set result = CommonUtils.set();
        switch (type) {
            case 8192: {
                result.add("ON CONNECT");
                return result;
            }
            case 8193: {
                result.add("ON DISCONNECT");
                return result;
            }
            case 8194: {
                result.add("ON TRANSACTION START");
                return result;
            }
            case 8195: {
                result.add("ON TRANSACTION COMMIT");
                return result;
            }
            case 8196: {
                result.add("ON TRANSACTION ROLLBACK");
                return result;
            }
        }
        int tmp = type & 7;
        String action = this.getTriggerEvent(tmp);
        result.add(action);
        tmp = type >> 3;
        if (tmp == 0) {
            return result;
        }
        action = this.getTriggerEvent(tmp &= 3);
        if (!CommonUtils.isEmpty((CharSequence)action)) {
            result.add(action);
        }
        if ((tmp = type >> 5) == 0) {
            return result;
        }
        action = this.getTriggerEvent(tmp &= 3);
        if (!CommonUtils.isEmpty((CharSequence)action)) {
            result.add(action);
        }
        return result;
    }

    private String getTriggerEvent(int tmp) {
        switch (tmp) {
            case 1: 
            case 2: {
                return "INSERT";
            }
            case 3: 
            case 4: {
                return "UPDATE";
            }
            case 5: 
            case 6: {
                return "DELETE";
            }
        }
        return "";
    }
}

