/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.firebird.metadata;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.schemas.AbstractColumn;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StringUtils;
import java.util.Map;
import java.util.regex.Pattern;

public class FirebirdUtils {
    private static final Pattern defaultPattern = Pattern.compile("\\s*DEFAULT\\s+(.*)s*", 10);
    private static final Pattern CHECK_PATTERN = Pattern.compile("\\s*CHECK\\s*[(](.*)[)]\\s*", 42);
    private static final Map<String, String> PRIV_CACHE = CommonUtils.upperMap();

    private FirebirdUtils() {
    }

    public static void setDefaultConstraint(AbstractColumn<?> column, String condition) {
        if (CommonUtils.isEmpty((CharSequence)condition)) {
            return;
        }
        String val = StringUtils.getGroupString((Pattern)defaultPattern, (String)condition, (int)1);
        if (val == null) {
            return;
        }
        column.setDefaultValue(val);
    }

    public static String convertCheckConstraint(String checkConstraintSource) {
        if (CommonUtils.isEmpty((CharSequence)checkConstraintSource)) {
            return checkConstraintSource;
        }
        String val = StringUtils.getGroupString((Pattern)CHECK_PATTERN, (String)checkConstraintSource, (int)1);
        return val;
    }

    protected static String getPrivilege(String priv) {
        String privilege = PRIV_CACHE.get(priv);
        if (privilege != null) {
            return privilege;
        }
        return priv;
    }

    public static void setDbType(AbstractColumn<?> column, int type, int subType, int length, int precision, int scale, int segmentLength) {
        column.setLength(0L);
        column.setOctetLength(0L);
        column.setScale(0);
        block0 : switch (type) {
            case 7: {
                column.setDataTypeName("SMALLINT");
                column.setDataType(DataType.SMALLINT);
                column.setOctetLength(2L);
                break;
            }
            case 8: {
                column.setDataTypeName("INTEGER");
                column.setDataType(DataType.INT);
                column.setOctetLength(4L);
                break;
            }
            case 10: {
                column.setDataTypeName("FLOAT");
                column.setDataType(DataType.FLOAT);
                column.setOctetLength(4L);
                break;
            }
            case 12: {
                column.setDataTypeName("DATE");
                column.setDataType(DataType.DATE);
                column.setOctetLength((long)length);
                break;
            }
            case 13: {
                column.setDataTypeName("TIME");
                column.setDataType(DataType.TIME);
                column.setOctetLength((long)length);
                break;
            }
            case 14: {
                column.setDataTypeName("CHAR");
                column.setDataType(DataType.CHAR);
                column.setLength((long)length);
                column.setOctetLength((long)length);
                break;
            }
            case 16: {
                switch (subType) {
                    case 1: {
                        column.setDataTypeName("NUMERIC");
                        column.setDataType(DataType.NUMERIC);
                        column.setLength((long)precision);
                        column.setScale(scale);
                        break block0;
                    }
                    case 2: {
                        column.setDataTypeName("DECIMAL");
                        column.setDataType(DataType.DECIMAL);
                        column.setLength((long)precision);
                        column.setScale(scale);
                        break block0;
                    }
                }
                column.setDataTypeName("BIGINT");
                column.setDataType(DataType.BIGINT);
                column.setOctetLength((long)length);
                break;
            }
            case 27: {
                column.setDataTypeName("DOUBLE PRECISION");
                column.setDataType(DataType.DOUBLE);
                column.setOctetLength((long)length);
                break;
            }
            case 35: {
                column.setDataTypeName("TIMESTAMP");
                column.setDataType(DataType.TIMESTAMP);
                column.setOctetLength((long)length);
                break;
            }
            case 37: {
                column.setDataTypeName("VARCHAR");
                column.setDataType(DataType.VARCHAR);
                column.setLength((long)length);
                column.setOctetLength((long)length);
                break;
            }
            case 261: {
                switch (subType) {
                    case 0: {
                        column.setDataTypeName("BLOB SUB_TYPE BINARY");
                        column.setDataType(DataType.BLOB);
                        column.setLength((long)segmentLength);
                        column.setOctetLength((long)segmentLength);
                        break block0;
                    }
                    case 1: {
                        column.setDataTypeName("BLOB SUB_TYPE TEXT");
                        column.setDataType(DataType.CLOB);
                        column.setLength((long)segmentLength);
                        column.setOctetLength((long)segmentLength);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    static {
        PRIV_CACHE.put("S", "SELECT");
        PRIV_CACHE.put("I", "INSERT");
        PRIV_CACHE.put("U", "UPDATE");
        PRIV_CACHE.put("X", "EXECUTE");
        PRIV_CACHE.put("D", "DELETE");
        PRIV_CACHE.put("R", "REFERENCES");
        PRIV_CACHE.put("A", "ALL");
    }
}

