/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.firebird.resolver;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.DialectUtils;
import com.sqlapp.data.db.dialect.firebird.Firebird;
import com.sqlapp.data.db.dialect.firebird.Firebird20;
import com.sqlapp.data.db.dialect.firebird.Firebird25;
import com.sqlapp.data.db.dialect.firebird.Firebird30;
import com.sqlapp.data.db.dialect.resolver.ProductNameDialectResolver;
import com.sqlapp.data.db.dialect.resolver.VersionResolver;

public class FirebirdDialectResolver
extends ProductNameDialectResolver {
    private static final long serialVersionUID = 1L;

    public FirebirdDialectResolver() {
        super("Firebird.*", (VersionResolver)new FirebirdVersionResolver());
    }

    public static class FirebirdVersionResolver
    implements VersionResolver {
        private static final long serialVersionUID = 1L;

        public Dialect getDialect(int majorVersion, int minorVersion, Integer revision) {
            if (majorVersion >= 3) {
                return DialectHolder.defaultDialect30;
            }
            if (majorVersion >= 2) {
                if (minorVersion < 5) {
                    return DialectHolder.defaultDialect20;
                }
                return DialectHolder.defaultDialect25;
            }
            return DialectHolder.defaultDialect;
        }

        public static class DialectHolder {
            static final Dialect defaultDialect30 = DialectUtils.getInstance(Firebird30.class);
            static final Dialect defaultDialect25 = DialectUtils.getInstance(Firebird25.class, () -> defaultDialect30);
            static final Dialect defaultDialect20 = DialectUtils.getInstance(Firebird20.class, () -> defaultDialect25);
            static final Dialect defaultDialect = DialectUtils.getInstance(Firebird.class, () -> defaultDialect20);
        }
    }
}

