SELECT
    i.RDB$RELATION_NAME AS TABLE_NAME
  , i.RDB$UNIQUE_FLAG AS NON_UNIQUE
  , i.RDB$INDEX_NAME AS INDEX_NAME
  , iss.RDB$FIELD_NAME AS COLUMN_NAME
  , i.RDB$INDEX_TYPE AS IS_DESC
  , i.RDB$DESCRIPTION AS DESCRIPTION
  , i.RDB$INDEX_INACTIVE AS INDEX_INACTIVE
--  , RDB$FOREIGN_KEY
FROM RDB$INDICES i
INNER JOIN RDB$INDEX_SEGMENTS iss
  ON (i.RDB$INDEX_NAME = iss.RDB$INDEX_NAME)
WHERE RDB$FOREIGN_KEY IS NULL
  /*if isNotEmpty(tableName)*/
  AND i.RDB$RELATION_NAME IN /*tableName*/('%')
  /*end*/
  /*if isNotEmpty(indexName)*/
  AND i.RDB$INDEX_NAME IN /*indexName*/('%')
  /*end*/
  /*if readerOptions.excludeSystemObjects */
  AND i.RDB$SYSTEM_FLAG=0
  /*end*/
  AND NOT EXISTS
  (
      SELECT 1
      FROM RDB$RELATION_CONSTRAINTS c
      WHERE c.RDB$INDEX_NAME=i.RDB$INDEX_NAME
  )
ORDER BY i.RDB$RELATION_NAME, i.RDB$INDEX_NAME, iss.RDB$FIELD_POSITION
