/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.firebird;

import com.sqlapp.data.db.datatype.BlobType;
import com.sqlapp.data.db.datatype.ClobType;
import com.sqlapp.data.db.datatype.DateType;
import com.sqlapp.data.db.datatype.DecimalType;
import com.sqlapp.data.db.datatype.TimeType;
import com.sqlapp.data.db.datatype.TimestampType;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.firebird.metadata.FirebirdCatalogReader;
import com.sqlapp.data.db.dialect.firebird.sql.FirebirdSqlFactoryRegistry;
import com.sqlapp.data.db.dialect.firebird.util.FirebirdSqlBuilder;
import com.sqlapp.data.db.dialect.firebird.util.FirebirdSqlSplitter;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.schemas.CascadeRule;
import com.sqlapp.util.CommonUtils;
import java.util.function.Supplier;

public class Firebird
extends Dialect {
    private static final long serialVersionUID = 5526324282610211323L;
    private static final long SIZE_MAX = CommonUtils.LEN_2GB - 1L;
    private static String[] DELIMITERS = new String[]{"@", "$", "%", "/", "!"};

    protected Firebird(Supplier<Dialect> nextVersionDialectSupplier) {
        super(nextVersionDialectSupplier);
    }

    protected void registerDataType() {
        this.getDbDataTypes().addChar(32767L);
        this.getDbDataTypes().addVarchar(32765L);
        ((ClobType)this.getDbDataTypes().addClob("BLOB SUB_TYPE TEXT", SIZE_MAX).addFormats(new String[]{"BLOB SUBTYPE 1"})).setCreateFormat("BLOB SUB_TYPE TEXT SEGMENT SIZE(", ")");
        ((BlobType)this.getDbDataTypes().addBlob("BLOB", SIZE_MAX).addFormats(new String[]{"BLOB SUBTYPE 0"})).setCreateFormat("BLOB SUB_TYPE BINARY SEGMENT SIZE(", ")");
        ((DecimalType)((DecimalType)this.getDbDataTypes().addDecimal().setDefaultPrecision(Integer.valueOf(18))).setDefaultScale(Integer.valueOf(5))).setMaxPrecision(Integer.valueOf(18)).setMaxScale(Integer.valueOf(18));
        ((DecimalType)((DecimalType)this.getDbDataTypes().addNumeric().setDefaultPrecision(Integer.valueOf(18))).setDefaultScale(Integer.valueOf(5))).setMaxPrecision(Integer.valueOf(18)).setMaxScale(Integer.valueOf(18));
        this.getDbDataTypes().addBoolean("DECIMAL(1,0)", "DECIMAL(1,0)", "0");
        this.getDbDataTypes().addSmallInt();
        this.getDbDataTypes().addInt("INTEGER").setCreateFormat("INTEGER");
        this.getDbDataTypes().addBigInt();
        this.getDbDataTypes().addUUID().setAsVarcharType();
        this.getDbDataTypes().addReal("FLOAT");
        this.getDbDataTypes().addDouble().addFormats(new String[]{"DOUBLE PRECISION"});
        ((DateType)this.getDbDataTypes().addDate().setLiteral("'", "'")).setDefaultValueLiteral(this.getCurrentDateFunction());
        ((TimeType)((TimeType)this.getDbDataTypes().addTime().setLiteral("'", "'")).setCreateFormat("TIME")).setDefaultValueLiteral(this.getCurrentTimeFunction());
        ((TimestampType)((TimestampType)this.getDbDataTypes().addTimestamp().setLiteral("'", "'")).setCreateFormat("TIMESTAMP")).setDefaultValueLiteral(this.getCurrentTimestampFunction());
    }

    public String getProductName() {
        return "Firebird";
    }

    public String getSimpleName() {
        return "firebird";
    }

    public String getSequenceNextValString(String sequenceName) {
        return String.format("select gen_id(%s, 1 ) from RDB$DATABASE", sequenceName);
    }

    public boolean supportsWith() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public boolean supportsDropCascade() {
        return true;
    }

    public boolean supportsCascadeDelete() {
        return true;
    }

    public boolean supportsRuleOnDelete(CascadeRule rule) {
        return true;
    }

    public boolean supportsCascadeUpdate() {
        return true;
    }

    public boolean supportsRuleOnUpdate(CascadeRule rule) {
        return true;
    }

    public boolean supportsFunctionOverload() {
        return false;
    }

    public boolean supportsProcedureOverload() {
        return false;
    }

    public boolean supportsDomain() {
        return true;
    }

    public String domainCheckConstraintColumnName() {
        return "VALUE";
    }

    public int hashCode() {
        return this.getProductName().hashCode();
    }

    public CatalogReader getCatalogReader() {
        return new FirebirdCatalogReader(this);
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public SqlFactoryRegistry createSqlFactoryRegistry() {
        return new FirebirdSqlFactoryRegistry(this);
    }

    public FirebirdSqlBuilder createSqlBuilder() {
        return new FirebirdSqlBuilder(this);
    }

    public FirebirdSqlSplitter createSqlSplitter() {
        return new FirebirdSqlSplitter(this);
    }

    public void setChangeAndResetSqlDelimiter(SqlOperation operation) {
        if (!operation.getSqlText().contains(";")) {
            return;
        }
        String del = this.getDelimiter(operation.getSqlText(), DELIMITERS);
        operation.setTerminator(del);
        operation.setStartStatementTerminator("SET TERM ; " + del);
        operation.setEndStatementTerminator("SET TERM " + del + " ;");
    }

    public boolean isDdlRollbackable() {
        return true;
    }
}

