/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.firebird.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.CheckConstraintReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.CheckConstraint;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StringUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Pattern;

public class FirebirdCheckConstraintReader
extends CheckConstraintReader {
    private static final Pattern checkPattern = Pattern.compile("\\s*CHECK\\s*[(](.*)[)]\\s*", 42);

    public FirebirdCheckConstraintReader(Dialect dialect) {
        super(dialect);
    }

    protected List<CheckConstraint> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final TripleKeyMap colMap = CommonUtils.tripleKeyMap();
        final TripleKeyMap tMap = CommonUtils.tripleKeyMap();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Object catalog_name = null;
                Object schema_name = null;
                String name = CommonUtils.trim((String)this.getString(rs, "constraint_name"));
                String source = FirebirdCheckConstraintReader.this.convertCheckConstraint(CommonUtils.trim((String)this.getString(rs, "RDB$TRIGGER_SOURCE")));
                String column_name = CommonUtils.trim((String)this.getString(rs, "column_name"));
                String tableName = CommonUtils.trim((String)this.getString(rs, "table_name"));
                CheckConstraint c = (CheckConstraint)tMap.get(catalog_name, schema_name, (Object)name);
                List cols = (List)colMap.get(catalog_name, schema_name, (Object)name);
                if (c == null) {
                    c = new CheckConstraint(name, source, new Column[0]);
                    c.setTableName(tableName);
                    cols = CommonUtils.list();
                    tMap.put(schema_name, schema_name, (Object)name, (Object)c);
                    colMap.put(schema_name, schema_name, (Object)name, (Object)cols);
                }
                if (column_name != null) {
                    Column column = new Column(column_name);
                    column.setTableName(tableName);
                    cols.add(column);
                }
            }
        });
        for (CheckConstraint c : tMap.toList()) {
            List cols = (List)colMap.get((Object)c.getCatalogName(), (Object)c.getSchemaName(), (Object)c.getName());
            if (cols.size() != 1) continue;
            c.addColumns(cols);
        }
        return tMap.toList();
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("checkConstraints.sql");
    }

    private String convertCheckConstraint(String checkConstraintSource) {
        if (CommonUtils.isEmpty((CharSequence)checkConstraintSource)) {
            return checkConstraintSource;
        }
        String val = StringUtils.getGroupString((Pattern)checkPattern, (String)checkConstraintSource, (int)1);
        return val;
    }
}

