/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.firebird.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.firebird.metadata.FirebirdUtils;
import com.sqlapp.data.db.metadata.DomainReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Domain;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class FirebirdDomainReader
extends DomainReader {
    protected FirebirdDomainReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Domain> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNodeCache().getString("domains.sql");
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Domain domain = FirebirdDomainReader.this.createDomain(rs);
                result.add(domain);
            }
        });
        return result;
    }

    protected Domain createDomain(ExResultSet rs) throws SQLException {
        Domain obj = new Domain(this.getString((ResultSet)rs, "RDB$FIELD_NAME"));
        int nullFlag = rs.getInt("RDB$NULL_FLAG");
        obj.setNullable(1 != nullFlag);
        FirebirdUtils.setDefaultConstraint(obj, CommonUtils.trim((String)this.getString((ResultSet)rs, "RDB$DEFAULT_SOURCE")));
        this.setCheckConstraint(obj, CommonUtils.trim((String)this.getString((ResultSet)rs, "RDB$VALIDATION_SOURCE")));
        int segmentLength = rs.getInt("RDB$SEGMENT_LENGTH");
        int length = rs.getInt("RDB$FIELD_LENGTH");
        int precision = rs.getInt("RDB$FIELD_PRECISION");
        int scale = CommonUtils.abs((int)rs.getInt("RDB$FIELD_SCALE"));
        int type = rs.getInt("RDB$FIELD_TYPE");
        int subType = rs.getInt("RDB$FIELD_SUB_TYPE");
        FirebirdUtils.setDbType(obj, type, subType, length, precision, scale, segmentLength);
        return obj;
    }

    private void setCheckConstraint(Domain domain, String condition) {
        if (CommonUtils.isEmpty((CharSequence)condition)) {
            return;
        }
        String val = FirebirdUtils.convertCheckConstraint(condition);
        domain.setCheck(val);
    }
}

