/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.firebird.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.firebird.metadata.FirebirdFunctionArgumentReader;
import com.sqlapp.data.db.metadata.FunctionReader;
import com.sqlapp.data.db.metadata.RoutineArgumentReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Function;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class FirebirdFunctionReader
extends FunctionReader {
    protected FirebirdFunctionReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Function> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Function function = FirebirdFunctionReader.this.createFunction(rs);
                result.add(function);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("functions.sql");
    }

    protected Function createFunction(ExResultSet rs) throws SQLException {
        String name = CommonUtils.trim((String)this.getString((ResultSet)rs, "RDB$FUNCTIONS_NAME"));
        Function obj = new Function(name);
        return obj;
    }

    protected RoutineArgumentReader<?> newRoutineArgumentReader() {
        return new FirebirdFunctionArgumentReader(this.getDialect());
    }
}

