/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.firebird.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.IndexReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.Order;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class FirebirdIndexReader
extends IndexReader {
    public FirebirdIndexReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Index> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        final TripleKeyMap map = CommonUtils.tripleKeyMap();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                boolean isDesc;
                String catalog_name = null;
                String schema_name = null;
                String name = CommonUtils.trim((String)this.getString(rs, "index_name"));
                String columnName = CommonUtils.trim((String)this.getString(rs, "column_name"));
                boolean uniqueness = !rs.getBoolean("NON_UNIQUE");
                Index index = (Index)map.get(catalog_name, schema_name, (Object)name);
                if (index == null) {
                    index = new Index(name);
                    index.setCatalogName(catalog_name);
                    index.setSchemaName(schema_name);
                    index.setTableName(CommonUtils.trim((String)this.getString(rs, "table_name")));
                    index.setUnique(uniqueness);
                    index.setEnable(!rs.getBoolean("INDEX_INACTIVE"));
                    index.setRemarks(this.getString(rs, "DESCRIPTION"));
                    map.put(catalog_name, schema_name, (Object)name, (Object)index);
                    result.add(index);
                }
                if (isDesc = rs.getBoolean("IS_DESC")) {
                    index.getColumns().add(new Column(columnName), Order.Desc);
                } else {
                    index.getColumns().add(new Column(columnName), Order.Asc);
                }
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("indexes.sql");
    }
}

