/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.firebird.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.firebird.metadata.FirebirdProcedureArgumentReader;
import com.sqlapp.data.db.metadata.ProcedureReader;
import com.sqlapp.data.db.metadata.RoutineArgumentReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Procedure;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class FirebirdProcedureReader
extends ProcedureReader {
    protected FirebirdProcedureReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Procedure> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNodeCache().getString("procedures.sql");
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Procedure procedure = FirebirdProcedureReader.this.createProcedure(rs);
                result.add(procedure);
            }
        });
        return result;
    }

    protected Procedure createProcedure(ExResultSet rs) throws SQLException {
        String name = CommonUtils.trim((String)this.getString((ResultSet)rs, "RDB$PROCEDURE_NAME"));
        String source = CommonUtils.trim((String)this.getString((ResultSet)rs, "RDB$PROCEDURE_SOURCE"));
        Procedure procedure = new Procedure(name);
        if (this.getReaderOptions().isReadStatement()) {
            procedure.setStatement(source);
        }
        return procedure;
    }

    protected RoutineArgumentReader<?> newRoutineArgumentReader() {
        return new FirebirdProcedureArgumentReader(this.getDialect());
    }
}

