/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.firebird.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.firebird.metadata.FirebirdCheckConstraintReader;
import com.sqlapp.data.db.dialect.firebird.metadata.FirebirdColumnReader;
import com.sqlapp.data.db.dialect.firebird.metadata.FirebirdForeignKeyConstraintReader;
import com.sqlapp.data.db.dialect.firebird.metadata.FirebirdIndexReader;
import com.sqlapp.data.db.dialect.firebird.metadata.FirebirdUniqueConstraintReader;
import com.sqlapp.data.db.metadata.CheckConstraintReader;
import com.sqlapp.data.db.metadata.ColumnReader;
import com.sqlapp.data.db.metadata.ExcludeConstraintReader;
import com.sqlapp.data.db.metadata.ForeignKeyConstraintReader;
import com.sqlapp.data.db.metadata.IndexReader;
import com.sqlapp.data.db.metadata.TableReader;
import com.sqlapp.data.db.metadata.UniqueConstraintReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class FirebirdTableReader
extends TableReader {
    protected FirebirdTableReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Table> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Table obj = FirebirdTableReader.this.createTable(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("tables.sql");
    }

    protected Table createTable(ExResultSet rs) throws SQLException {
        Table obj = this.createTable(CommonUtils.trim((String)this.getString((ResultSet)rs, "RDB$RELATION_NAME")));
        obj.setRemarks(CommonUtils.trim((String)this.getString((ResultSet)rs, "RDB$DESCRIPTION")));
        return obj;
    }

    protected ColumnReader newColumnReader() {
        return new FirebirdColumnReader(this.getDialect());
    }

    protected IndexReader newIndexReader() {
        return new FirebirdIndexReader(this.getDialect());
    }

    protected UniqueConstraintReader newUniqueConstraintReader() {
        return new FirebirdUniqueConstraintReader(this.getDialect());
    }

    protected CheckConstraintReader newCheckConstraintReader() {
        return new FirebirdCheckConstraintReader(this.getDialect());
    }

    protected ForeignKeyConstraintReader newForeignKeyConstraintReader() {
        return new FirebirdForeignKeyConstraintReader(this.getDialect());
    }

    protected ExcludeConstraintReader newExcludeConstraintReader() {
        return null;
    }
}

