/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.firebird.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.UniqueConstraintReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Order;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class FirebirdUniqueConstraintReader
extends UniqueConstraintReader {
    public FirebirdUniqueConstraintReader(Dialect dialect) {
        super(dialect);
    }

    protected List<UniqueConstraint> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final TripleKeyMap map = CommonUtils.tripleKeyMap();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String catalog_name = null;
                String schema_name = null;
                String table_name = this.getString(rs, "table_name");
                String constraint_name = this.getString(rs, "constraint_name");
                boolean primary = !"unique".equalsIgnoreCase(this.getString(rs, "CONSTRAINT_TYPE"));
                UniqueConstraint c = (UniqueConstraint)map.get(catalog_name, schema_name, (Object)constraint_name);
                if (c == null) {
                    c = new UniqueConstraint(constraint_name, primary);
                    c.setCatalogName(catalog_name);
                    c.setSchemaName(schema_name);
                    c.setTableName(table_name);
                    c.setEnable(!rs.getBoolean("INDEX_INACTIVE"));
                    String index_name = this.getString(rs, "index_name");
                    map.put(catalog_name, schema_name, (Object)constraint_name, (Object)c);
                }
                Column column = new Column(this.getString(rs, "column_name"));
                Order order = null;
                boolean isDesc = rs.getBoolean("IS_DESC");
                order = isDesc ? Order.Desc : Order.Asc;
                column.setTableName(table_name);
                c.getColumns().add(column, order);
            }
        });
        return map.toList();
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("uniqueConstraints.sql");
    }
}

