/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.firebird.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.firebird.metadata.FirebirdColumnReader;
import com.sqlapp.data.db.metadata.ColumnReader;
import com.sqlapp.data.db.metadata.ExcludeConstraintReader;
import com.sqlapp.data.db.metadata.IndexReader;
import com.sqlapp.data.db.metadata.ViewReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.View;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class FirebirdViewReader
extends ViewReader {
    protected FirebirdViewReader(Dialect dialect) {
        super(dialect);
    }

    protected ColumnReader newColumnReader() {
        return new FirebirdColumnReader(this.getDialect());
    }

    protected List<Table> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Table view = FirebirdViewReader.this.createTable(rs);
                result.add(view);
            }
        });
        return result;
    }

    protected Table createTable(ExResultSet rs) throws SQLException {
        String view_name = CommonUtils.trim((String)this.getString((ResultSet)rs, "RDB$RELATION_NAME"));
        String text = CommonUtils.trim((String)this.getString((ResultSet)rs, "RDB$VIEW_SOURCE"));
        View table = this.createTable(view_name);
        if (this.getReaderOptions().isReadStatement()) {
            table.setStatement(text);
        }
        return table;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("views.sql");
    }

    protected IndexReader newIndexReader() {
        return null;
    }

    protected ExcludeConstraintReader newExcludeConstraintReader() {
        return null;
    }
}

