/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.firebird.sql;

import com.sqlapp.data.db.dialect.firebird.util.FirebirdSqlBuilder;
import com.sqlapp.data.db.sql.AbstractCreateTriggerFactory;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Trigger;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SeparatedStringBuilder;
import java.util.Collection;
import java.util.List;

public class FirebirdCreateTriggerFactory
extends AbstractCreateTriggerFactory<FirebirdSqlBuilder> {
    protected void addCreateObject(Trigger obj, FirebirdSqlBuilder builder) {
        if (!CommonUtils.isEmpty((Collection)obj.getDefinition())) {
            builder._add(obj.getDefinition());
        } else {
            ((FirebirdSqlBuilder)builder.create()).trigger();
            builder.name((AbstractSchemaObject)obj, this.getOptions().isDecorateSchemaName());
            this.addCreateObjectDetail(obj, builder);
        }
    }

    protected void addCreateObjectDetail(Trigger obj, FirebirdSqlBuilder builder) {
        builder.lineBreak();
        ((FirebirdSqlBuilder)builder._for()).name(obj.getTableName());
        builder.lineBreak();
        if (obj.isEnable()) {
            builder.active();
        } else {
            builder.inactive();
        }
        String position = obj.getSpecifics().get("POSITION");
        if (!"0".equals(position) && !CommonUtils.isEmpty((CharSequence)position)) {
            builder.lineBreak();
            ((FirebirdSqlBuilder)((FirebirdSqlBuilder)builder.partition()).space())._add(position);
        }
        this.addEventManipulationText(obj, builder);
        this.addCreateTriggerBody(obj, builder);
    }

    protected void addEventManipulationText(Trigger obj, FirebirdSqlBuilder builder) {
        SeparatedStringBuilder sepBuilder = new SeparatedStringBuilder(" OR ");
        sepBuilder.add((Collection)obj.getEventManipulation());
        if (obj.getActionTiming() != null) {
            builder.lineBreak();
            builder._add(obj.getActionTiming());
        }
        if (!CommonUtils.isEmpty((Collection)obj.getEventManipulation())) {
            builder.lineBreak();
            builder._add(sepBuilder.toString());
        }
    }

    protected void addCreateTriggerBody(Trigger obj, FirebirdSqlBuilder builder) {
        builder.lineBreak();
        String first = CommonUtils.toUpperCase((String)((String)CommonUtils.first((List)obj.getStatement())));
        if (first != null && !first.startsWith("AS")) {
            builder.as();
            builder.lineBreak();
        }
        builder._add(this.toString(obj.getStatement()));
    }
}

