/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.firebird.util;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.util.SqlSplitter;
import com.sqlapp.data.db.dialect.util.SqlTokenizer;
import com.sqlapp.data.db.dialect.util.StringHolder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FirebirdSqlSplitter
extends SqlSplitter {
    private static final Pattern CHANGE_DELIMITER = Pattern.compile("set\\s+term\\s+(?<to>[^\\s]+)\\s+(?<from>[^\\s]+)\\s*", 2);

    public FirebirdSqlSplitter(Dialect dialect) {
        super(dialect);
    }

    protected SqlTokenizer createSqlTokenizer(String input) {
        return new SqlTokenizer(input){

            protected boolean isChangeDelimiter(String text, StringHolder stringHolder) {
                Matcher matcher = CHANGE_DELIMITER.matcher(text);
                if (matcher.matches()) {
                    String to = matcher.group("to");
                    this.setCurrentDelimiter(to);
                    stringHolder.addPosition(matcher.group(0).length());
                    return true;
                }
                return false;
            }
        };
    }
}

