/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.virtica;

import com.sqlapp.data.db.datatype.BigIntType;
import com.sqlapp.data.db.datatype.BinaryType;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.datatype.DateType;
import com.sqlapp.data.db.datatype.DecimalType;
import com.sqlapp.data.db.datatype.DoubleType;
import com.sqlapp.data.db.datatype.LongVarcharType;
import com.sqlapp.data.db.datatype.TimeType;
import com.sqlapp.data.db.datatype.TimestampType;
import com.sqlapp.data.db.datatype.UUIDType;
import com.sqlapp.data.db.datatype.VarBinaryType;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.virtica.metadata.VirticaCatalogReader;
import com.sqlapp.data.db.dialect.virtica.sql.VirticaSqlFactoryRegistry;
import com.sqlapp.data.db.dialect.virtica.util.VirticaSqlBuilder;
import com.sqlapp.data.db.dialect.virtica.util.VirticaSqlSplitter;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import java.util.function.Supplier;

public class Virtica
extends Dialect {
    private static final long serialVersionUID = -8635862003765087520L;
    private static final long SIZE_MAX = 65000L;
    private static final long SIZE_MAX2 = 32000000L;

    protected Virtica(Supplier<Dialect> nextVersionDialectSupplier) {
        super(nextVersionDialectSupplier);
    }

    protected void registerDataType() {
        this.getDbDataTypes().addChar(65000L).setDefaultLength((Number)1);
        this.getDbDataTypes().addVarchar(65000L).setDefaultLength((Number)1);
        ((LongVarcharType)this.getDbDataTypes().addLongVarchar("LONG VARCHAR", 32000000L).setDefaultLength((Number)1)).setCreateFormat("LONG VARCHAR");
        ((UUIDType)((UUIDType)this.getDbDataTypes().addUUID("BINARY(16)").setLiteral("'", "'")).setFormats(new String[]{"BINARY\\s*\\(\\s*16\\s*\\)\\s*"})).setAsBinaryType();
        this.getDbDataTypes().addBoolean();
        ((BinaryType)((BinaryType)this.getDbDataTypes().addBinary("BINARY", 65000L).setLiteral("X'", "'")).setDefaultValueLiteral("X'0'")).setSizeSarrogation(16L, DataType.UUID);
        ((VarBinaryType)this.getDbDataTypes().addVarBinary("VARBINARY", 65000L).setLiteral("X'", "'")).setDefaultValueLiteral("X'0'");
        ((VarBinaryType)((VarBinaryType)((VarBinaryType)((VarBinaryType)((VarBinaryType)this.getDbDataTypes().addVarBinary("LONG VARCHAR FOR BIT DATA", 32700L).setDefaultLength((Number)32700)).setCreateFormat("LONG VARCHAR FOR BIT DATA")).setFormats(new String[]{"LONG VARCHAR FOR BIT DATA"})).setLiteral("X'", "'")).setDefaultValueLiteral("X'0'")).setDeprecated(this.getDbDataTypes().getDbType(DataType.LONGVARBINARY));
        ((BigIntType)((BigIntType)((BigIntType)this.getDbDataTypes().addBigInt().addFormats(new String[]{"INTEGER"})).addFormats(new String[]{"INT"})).addFormats(new String[]{"INT8"})).addFormats(new String[]{"SMALLINT"});
        ((DoubleType)((DoubleType)((DoubleType)this.getDbDataTypes().addDouble().addFormats(new String[]{"DOUBLE PRECISION"})).addFormats(new String[]{"FLOAT"})).addFormats(new String[]{"REAL"})).addFormats(new String[]{"FLOAT\\s*\\(.*\\)\\s*"});
        ((DateType)this.getDbDataTypes().addDate().setLiteral("'", "'")).setDefaultValueLiteral(this.getCurrentDateFunction());
        ((TimeType)this.getDbDataTypes().addTime().setLiteral("'", "'")).setDefaultValueLiteral(this.getCurrentTimeFunction());
        ((TimeType)this.getDbDataTypes().addTimeWithTimeZone().setLiteral("'", "'")).setDefaultValueLiteral(this.getCurrentTimeFunction());
        ((TimestampType)((TimestampType)((TimestampType)this.getDbDataTypes().addTimestamp().setLiteral("'", "'")).addFormats(new String[]{"DATETIME"})).addFormats(new String[]{"SMALLDATETIME"})).setDefaultValueLiteral(this.getCurrentTimestampFunction());
        ((TimestampType)this.getDbDataTypes().addTimestampWithTimeZoneType().setLiteral("'", "'")).setDefaultValueLiteral(this.getCurrentTimestampFunction());
        ((DecimalType)((DecimalType)this.getDbDataTypes().addDecimal().setDefaultPrecision(Integer.valueOf(37))).setDefaultScale(Integer.valueOf(15))).setMaxPrecision(Integer.valueOf(31)).setMaxScale(Integer.valueOf(31));
        ((DecimalType)((DecimalType)this.getDbDataTypes().addNumeric().setDefaultPrecision(Integer.valueOf(37))).setDefaultScale(Integer.valueOf(15))).setMaxPrecision(Integer.valueOf(31)).setMaxScale(Integer.valueOf(31));
        this.getDbDataTypes().addInterval();
    }

    public String getProductName() {
        return "Virtica";
    }

    public String getSimpleName() {
        return "virtica";
    }

    public boolean supportsWith() {
        return true;
    }

    public String getCurrentDateFunction() {
        return "CURRENT_DATE";
    }

    public CatalogReader getCatalogReader() {
        return new VirticaCatalogReader(this);
    }

    public int hashCode() {
        return this.getProductName().hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public SqlFactoryRegistry createSqlFactoryRegistry() {
        return new VirticaSqlFactoryRegistry(this);
    }

    public VirticaSqlBuilder createSqlBuilder() {
        return new VirticaSqlBuilder(this);
    }

    public VirticaSqlSplitter createSqlSplitter() {
        return new VirticaSqlSplitter(this);
    }

    protected String doQuote(String target) {
        StringBuilder builder = new StringBuilder(target.length() + 2);
        builder.append(this.getOpenQuote()).append(target.replace("\"", "\"\"")).append(this.getCloseQuote());
        return builder.toString();
    }
}

