/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.virtica.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.FunctionReader;
import com.sqlapp.data.db.metadata.RoutineArgumentReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.Function;
import com.sqlapp.data.schemas.FunctionReturning;
import com.sqlapp.data.schemas.NamedArgument;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.properties.DataTypeLengthProperties;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VirticaFunctionReader
extends FunctionReader {
    private static final Pattern NAMED_ARGUMENT_PATTERN = Pattern.compile("\\s*([^\\s])\\s+(.*)");

    protected VirticaFunctionReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Function> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNode(productVersionInfo);
        final TripleKeyMap map = new TripleKeyMap();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Function function = VirticaFunctionReader.this.createFunction(rs);
                map.put((Object)function.getCatalogName(), (Object)function.getSchemaName(), (Object)function.getSpecificName(), (Object)function);
            }
        });
        return map.toList();
    }

    protected Function createFunction(ExResultSet rs) throws SQLException {
        String[] splits;
        Function obj = new Function(this.getString((ResultSet)rs, "function_name"));
        obj.setDefinition(this.getString((ResultSet)rs, "FUNCTION_DEFINITION"));
        obj.setRemarks(this.getString((ResultSet)rs, "COMMENT"));
        this.setReturning(rs, obj);
        String args = this.getString((ResultSet)rs, "FUNCTION_ARGUMENT_TYPE");
        for (String split : splits = args.split("\\s*,\\s*")) {
            NamedArgument argument = this.createNamedArgument(split);
            obj.getArguments().add((AbstractNamedObject)argument);
        }
        this.setSpecifics(rs, "VOLATILITY", (SpecificsProperty)obj);
        this.setSpecifics(rs, "IS_FENCED", (SpecificsProperty)obj);
        this.setSpecifics(rs, "VOLATILITY", (SpecificsProperty)obj);
        return obj;
    }

    protected void setReturning(ExResultSet rs, Function obj) throws SQLException {
        String data_type = this.getString((ResultSet)rs, "FUNCTION_RETURN_TYPE");
        FunctionReturning ret = obj.getReturning();
        ret.setDataTypeName(data_type);
        this.getDialect().setDbType(data_type, null, null, (DataTypeLengthProperties)ret);
    }

    protected NamedArgument createNamedArgument(String parameter) throws SQLException {
        NamedArgument obj = new NamedArgument();
        Matcher matcher = NAMED_ARGUMENT_PATTERN.matcher(parameter);
        if (matcher.matches()) {
            obj.setName(matcher.group(1));
            this.getDialect().setDbType(matcher.group(2), null, null, (DataTypeLengthProperties)obj);
        }
        return obj;
    }

    protected SqlNode getSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("functions.sql");
    }

    protected RoutineArgumentReader<?> newRoutineArgumentReader() {
        return null;
    }
}

