/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.virtica.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.SequenceReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Sequence;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class VirticaSequenceReader
extends SequenceReader {
    protected VirticaSequenceReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Sequence> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Sequence sequence = VirticaSequenceReader.this.createSequence(rs);
                result.add(sequence);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("sequences.sql");
    }

    protected Sequence createSequence(ExResultSet rs) throws SQLException {
        Sequence obj = new Sequence(this.getString((ResultSet)rs, "sequence_name"));
        obj.setSchemaName(this.getString((ResultSet)rs, "SEQUENCE_SCHEMA"));
        obj.setMinValue(rs.getLong("MINIMUM"));
        obj.setMaxValue(rs.getLong("MAXIMUM"));
        obj.setIncrementBy(rs.getLong("INCREMENT_BY"));
        obj.setCacheSize((Number)rs.getLong("SESSION_CACHE_COUNT"));
        obj.setLastValue(rs.getLong("CURRENT_VALUE"));
        obj.setCycle(rs.getBoolean("ALLOW_CYCLE"));
        obj.setId(rs.getString("SEQUENCE_ID"));
        obj.setRemarks(this.getString((ResultSet)rs, "COMMENT"));
        this.setSpecifics(rs, "OWNER_NAME", (SpecificsProperty)obj);
        return obj;
    }
}

