/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.virtica.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.virtica.metadata.VirticaColumnReader;
import com.sqlapp.data.db.dialect.virtica.metadata.VirticaForeignKeyConstraintReader;
import com.sqlapp.data.db.dialect.virtica.metadata.VirticaUniqueConstraintReader;
import com.sqlapp.data.db.metadata.CheckConstraintReader;
import com.sqlapp.data.db.metadata.ColumnReader;
import com.sqlapp.data.db.metadata.ExcludeConstraintReader;
import com.sqlapp.data.db.metadata.ForeignKeyConstraintReader;
import com.sqlapp.data.db.metadata.IndexReader;
import com.sqlapp.data.db.metadata.TableReader;
import com.sqlapp.data.db.metadata.UniqueConstraintReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class VirticaTableReader
extends TableReader {
    protected VirticaTableReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Table> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Table table = VirticaTableReader.this.createTable(rs);
                result.add(table);
            }
        });
        return result;
    }

    protected Table createTable(ExResultSet rs) throws SQLException {
        Table obj = this.createTable(this.getString((ResultSet)rs, "table_name"));
        obj.setDialect(this.getDialect());
        obj.setSchemaName(this.getString((ResultSet)rs, "TABLE_SCHEMA"));
        obj.setRemarks(this.getString((ResultSet)rs, "remarks"));
        obj.setCreatedAt(rs.getTimestamp("CREATE_TIME"));
        obj.setId(rs.getString("TABLE_ID"));
        if (rs.getBoolean("IS_TEMP_TABLE")) {
            obj.setTableType(Table.TableType.Temporary);
        }
        if (rs.getBoolean("IS_FLEXTABLE")) {
            obj.setTableType(Table.TableType.Flex);
        }
        obj.setTableDataStoreType(Table.TableDataStoreType.Column);
        obj.setCreatedAt(rs.getTimestamp("CREATE_TIME"));
        obj.setRemarks(this.getString((ResultSet)rs, "COMMENT"));
        this.setSpecifics(rs, "commit_action", (SpecificsProperty)obj);
        this.setSpecifics(rs, "PARTITION_EXPRESSION", (SpecificsProperty)obj);
        this.setSpecifics(rs, "TABLE_DEFINITION", (SpecificsProperty)obj);
        return obj;
    }

    protected SqlNode getSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("tables.sql");
    }

    protected ColumnReader newColumnReader() {
        return new VirticaColumnReader(this.getDialect());
    }

    protected IndexReader newIndexReader() {
        return null;
    }

    protected UniqueConstraintReader newUniqueConstraintReader() {
        return new VirticaUniqueConstraintReader(this.getDialect());
    }

    protected CheckConstraintReader newCheckConstraintReader() {
        return null;
    }

    protected ForeignKeyConstraintReader newForeignKeyConstraintReader() {
        return new VirticaForeignKeyConstraintReader(this.getDialect());
    }

    protected ExcludeConstraintReader newExcludeConstraintReader() {
        return null;
    }
}

