/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.virtica.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.UniqueConstraintReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.QuadKeyMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class VirticaUniqueConstraintReader
extends UniqueConstraintReader {
    public VirticaUniqueConstraintReader(Dialect dialect) {
        super(dialect);
    }

    protected List<UniqueConstraint> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNode(productVersionInfo);
        final QuadKeyMap map = CommonUtils.quadKeyMap();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String catalogName = null;
                String schemaName = this.getString(rs, "table_schema");
                String tableName = this.getString(rs, "table_name");
                String constraint_name = this.getString(rs, "constraint_name");
                boolean primary = !"u".equalsIgnoreCase(this.getString(rs, "constraint_type"));
                UniqueConstraint c = (UniqueConstraint)map.get(catalogName, (Object)schemaName, (Object)tableName, (Object)constraint_name);
                if (c == null) {
                    c = new UniqueConstraint(constraint_name, primary);
                    c.setCatalogName(catalogName);
                    c.setSchemaName(schemaName);
                    c.setTableName(tableName);
                    map.put(catalogName, (Object)schemaName, (Object)tableName, (Object)constraint_name, (Object)c);
                }
                Column column = new Column(this.getString(rs, "column_name"));
                column.setTableName(tableName);
                c.getColumns().add(column);
            }
        });
        return map.toList();
    }

    protected SqlNode getSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("uniqueConstraints.sql");
    }
}

