/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.virtica.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.UserReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.User;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class VirticaUserReader
extends UserReader {
    protected VirticaUserReader(Dialect dialect) {
        super(dialect);
    }

    protected List<User> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                User obj = VirticaUserReader.this.createUser(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected SqlNode getSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("users.sql");
    }

    protected User createUser(ExResultSet rs) throws SQLException {
        User obj = new User(this.getString((ResultSet)rs, "user_name"));
        obj.setAdmin(rs.getBoolean("IS_SUPER_USER"));
        obj.setLockedAt(this.getTimestamp((ResultSet)rs, "LOCK_TIME"));
        this.setSpecifics(rs, "PROFILE_NAME", (SpecificsProperty)obj);
        this.setSpecifics(rs, "IS_LOCKED", (SpecificsProperty)obj);
        this.setSpecifics(rs, "RESOURCE_POOL", (SpecificsProperty)obj);
        this.setSpecifics(rs, "MEMORY_CAP_KB", (SpecificsProperty)obj);
        this.setSpecifics(rs, "TEMP_SPACE_CAP_KB", (SpecificsProperty)obj);
        this.setSpecifics(rs, "RUN_TIME_CAP", (SpecificsProperty)obj);
        this.setSpecifics(rs, "ALL_ROLES", (SpecificsProperty)obj);
        this.setSpecifics(rs, "DEFAULT_ROLES", (SpecificsProperty)obj);
        this.setSpecifics(rs, "SEARCH_PATH", (SpecificsProperty)obj);
        return obj;
    }
}

