/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.virtica.resolver;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.DialectUtils;
import com.sqlapp.data.db.dialect.resolver.ProductNameDialectResolver;
import com.sqlapp.data.db.dialect.resolver.VersionResolver;
import com.sqlapp.data.db.dialect.virtica.Virtica;
import com.sqlapp.data.db.dialect.virtica.Virtica72;
import com.sqlapp.data.db.dialect.virtica.Virtica80;

public class VirticaDialectResolver
extends ProductNameDialectResolver {
    private static final long serialVersionUID = 1L;

    public VirticaDialectResolver() {
        super("*.virtica", (VersionResolver)new VirticaVersionResolver());
    }

    static class VirticaVersionResolver
    implements VersionResolver {
        private static final long serialVersionUID = 1L;

        public Dialect getDialect(int majorVersion, int minorVersion, Integer revision) {
            if (majorVersion >= 8) {
                return DialectHolder.defaultDialect80;
            }
            if (majorVersion >= 7) {
                if (minorVersion > 1) {
                    return DialectHolder.defaultDialect72;
                }
                return DialectHolder.defaultDialect;
            }
            return DialectHolder.defaultDialect;
        }

        static class DialectHolder {
            static final Dialect defaultDialect80 = DialectUtils.getInstance(Virtica80.class);
            static final Dialect defaultDialect72 = DialectUtils.getInstance(Virtica72.class, () -> defaultDialect80);
            static final Dialect defaultDialect = DialectUtils.getInstance(Virtica.class, () -> defaultDialect72);

            DialectHolder() {
            }
        }
    }
}

