/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.virtica.util;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.util.SqlSplitter;
import com.sqlapp.data.db.dialect.util.SqlTokenizer;
import com.sqlapp.data.db.dialect.util.StringHolder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VirticaSqlSplitter
extends SqlSplitter {
    private static final Pattern CREATE_PATTERN = Pattern.compile("\\s*(CREATE|ALTER)\\s*.*", 42);
    private static final Pattern BEGIN_PATTERN = Pattern.compile("\\s*BEGIN\\s*", 42);
    private static final Pattern END_PATTERN = Pattern.compile("\\s*END\\s*(WITH\\s+CACHE\\s+RETENTION\\s+[0-9]+\\s*)?(OF\\s+[^;]+?)?;?", 42);

    public VirticaSqlSplitter(Dialect dialect) {
        super(dialect);
    }

    protected SqlTokenizer createSqlTokenizer(String input) {
        return new SqlTokenizer(input){

            protected boolean isStartStatement(String text, StringHolder stringHolder) {
                Matcher matcher = CREATE_PATTERN.matcher(text);
                if (matcher.matches()) {
                    int ePos;
                    block5: {
                        int delPos = stringHolder.indexOf(this.getCurrentDelimiter(), stringHolder.getPosition() + 10);
                        int beginPos = stringHolder.searchLineOf(BEGIN_PATTERN, stringHolder.getPosition() + 10);
                        if (beginPos < 0) {
                            return false;
                        }
                        if (delPos < beginPos) {
                            return false;
                        }
                        int i = beginPos;
                        while (true) {
                            int bPos;
                            if ((ePos = stringHolder.searchLineOf(END_PATTERN, i + 6)) < 0) {
                                stringHolder.throwInvalidTextException("[END] element not found.[" + stringHolder.substringAt() + "]");
                            }
                            if ((bPos = stringHolder.searchLineOf(BEGIN_PATTERN, i + 6)) < 0) break block5;
                            if (bPos >= ePos) break;
                            i = ePos + 3;
                        }
                        int last = stringHolder.indexOf(this.getCurrentDelimiter(), ePos + 3);
                        this.setPosition(last);
                        return true;
                    }
                    int last = stringHolder.indexOf(this.getCurrentDelimiter(), ePos + 3);
                    this.setPosition(last);
                    return true;
                }
                return false;
            }
        };
    }
}

