/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.data.converter.ByteConverter;
import com.sqlapp.util.BinaryUtils;
import com.sqlapp.util.FileUtils;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.UUID;

public abstract class AbstractBinaryConverter
extends AbstractConverter<byte[]> {
    private static final long serialVersionUID = 6419521281514049281L;
    private ByteConverter unitConverter;
    private static byte zero = 0;

    protected AbstractBinaryConverter() {
        this(new ByteConverter());
    }

    protected AbstractBinaryConverter(ByteConverter unitConverter) {
        this.unitConverter = unitConverter;
    }

    @Override
    public byte[] convertObject(Object value, Connection conn) {
        return this.convertObject(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] convertObject(Object value) {
        if (value == null) {
            return (byte[])this.getDefaultValue();
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof Blob) {
            Blob lob = (Blob)value;
            try {
                return lob.getBytes(1L, (int)lob.length());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (value instanceof String) {
            return this.stringToBinary((String)value);
        }
        if (value instanceof InputStream) {
            InputStream is = (InputStream)InputStream.class.cast(value);
            try {
                byte[] e = BinaryUtils.toBinary(is);
                return e;
            }
            finally {
                FileUtils.close(is);
            }
        }
        if (value instanceof UUID) {
            return BinaryUtils.toBinary((UUID)value);
        }
        if (value instanceof Long) {
            return BinaryUtils.toBinary((long)((Long)value));
        }
        if (value.getClass().isArray()) {
            int size = Array.getLength(value);
            byte[] bytes = new byte[size];
            for (int i = 0; i < size; ++i) {
                byte b;
                bytes[i] = b = this.objectToByte(Array.get(value, i));
            }
            return bytes;
        }
        return BinaryUtils.toBinary(value);
    }

    protected byte objectToByte(Object value) {
        if (value == null) {
            return zero;
        }
        Byte bt = this.unitConverter.convertObject(value);
        if (bt == null) {
            return zero;
        }
        return bt;
    }

    protected abstract byte[] stringToBinary(String var1);

    protected abstract String binaryToString(byte[] var1);

    @Override
    public String convertString(byte[] value) {
        if (value == null) {
            return null;
        }
        return this.binaryToString(value);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof AbstractBinaryConverter;
    }

    public ByteConverter getUnitConverter() {
        return this.unitConverter;
    }

    public void setUnitConverter(ByteConverter unitConverter) {
        this.unitConverter = unitConverter;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public byte[] copy(Object obj) {
        if (obj == null) {
            return null;
        }
        byte[] cnv = this.convertObject(obj);
        byte[] result = new byte[cnv.length];
        System.arraycopy(cnv, 0, result, 0, cnv.length);
        return result;
    }
}

