/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractBinaryConverter;
import com.sqlapp.data.converter.ByteConverter;
import com.sqlapp.util.CommonUtils;
import java.io.UnsupportedEncodingException;

public class ByteArrayConverter
extends AbstractBinaryConverter {
    private static final long serialVersionUID = 491425127888279448L;
    private String charset = "UTF8";

    public ByteArrayConverter() {
    }

    public ByteArrayConverter(ByteConverter unitConverter) {
        super(unitConverter);
    }

    @Override
    protected byte[] stringToBinary(String value) {
        if (value == null) {
            return null;
        }
        try {
            return value.getBytes(this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String binaryToString(byte[] value) {
        try {
            return new String(value, this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(this)) {
            return false;
        }
        if (!(obj instanceof ByteArrayConverter)) {
            return false;
        }
        ByteArrayConverter con = (ByteArrayConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getCharset(), con.getCharset());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

