/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractNumberConverter;
import com.sqlapp.util.CommonUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class FloatConverter
extends AbstractNumberConverter<Float> {
    private static final long serialVersionUID = -1020330152422724190L;
    protected static final Float ZERO = Float.valueOf(0.0f);
    private static final Float ONE = Float.valueOf(1.0f);

    @Override
    public Float convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (Float)this.getDefaultValue();
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof String) {
            return this.convert(this.trim((String)value));
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof OptionalInt) {
            OptionalInt op = (OptionalInt)value;
            return op.isPresent() ? Float.valueOf(op.getAsInt()) : null;
        }
        if (value instanceof OptionalLong) {
            OptionalLong op = (OptionalLong)value;
            return op.isPresent() ? Float.valueOf(op.getAsLong()) : null;
        }
        if (value instanceof OptionalDouble) {
            OptionalDouble op = (OptionalDouble)value;
            return op.isPresent() ? Float.valueOf((float)op.getAsDouble()) : null;
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return ONE;
            }
            return ZERO;
        }
        if (value instanceof byte[]) {
            return Float.valueOf(FloatConverter.toFloat((byte[])value));
        }
        return this.convert(value.toString());
    }

    private Float convert(String value) {
        if (CommonUtils.isEmpty(value)) {
            return null;
        }
        if (this.getNumberFormat() == null) {
            return Float.valueOf(value);
        }
        return Float.valueOf(this.parse(value).floatValue());
    }

    @Override
    public String convertString(Float value) {
        if (value == null) {
            return null;
        }
        if (this.getNumberFormat() == null) {
            return value.toString();
        }
        return this.format(value);
    }

    public static float toFloat(byte[] bytes) {
        ByteBuffer keyBuffer = ByteBuffer.wrap(bytes);
        keyBuffer.order(ByteOrder.BIG_ENDIAN);
        return keyBuffer.getFloat();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(this)) {
            return false;
        }
        if (!(obj instanceof FloatConverter)) {
            return false;
        }
        FloatConverter con = (FloatConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public Float copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj);
    }

    @Override
    protected boolean getParseIntegerOnly() {
        return false;
    }
}

