/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractJava8DateConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.util.CommonUtils;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;

public class InstantConverter
extends AbstractJava8DateConverter<Instant, InstantConverter>
implements NewValue<Instant> {
    private static final long serialVersionUID = 1212274814940098554L;

    @Override
    public Instant convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (Instant)this.getDefaultValue();
        }
        if (value instanceof Instant) {
            return (Instant)value;
        }
        if (value instanceof TemporalAccessor) {
            return Instant.from((TemporalAccessor)value);
        }
        if (value instanceof java.sql.Date) {
            return Instant.ofEpochMilli(((java.sql.Date)value).getTime());
        }
        if (value instanceof Date) {
            return ((Date)value).toInstant();
        }
        if (value instanceof Calendar) {
            Calendar cal = (Calendar)Calendar.class.cast(value);
            return this.toZonedDateTime(cal).toInstant();
        }
        if (value instanceof Number) {
            Instant ins = Instant.ofEpochMilli(((Number)value).longValue());
            return ins;
        }
        return (Instant)this.parseDate(value.toString());
    }

    @Override
    public String convertString(Instant value) {
        if (value == null) {
            return null;
        }
        DateTimeFormatter format = this.getFormat();
        if (format == null) {
            return this.toZonedDateTime(value).toString();
        }
        return this.toZonedDateTime(value).format(format);
    }

    public static InstantConverter newInstance() {
        InstantConverter dateConverter = new InstantConverter();
        return dateConverter;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof InstantConverter;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public Instant newValue() {
        return Instant.now();
    }

    @Override
    protected Instant parse(String value, DateTimeFormatter dateTimeFormatter) {
        Temporal temporal = this.parseTemporal(value, dateTimeFormatter);
        if (temporal == null) {
            return null;
        }
        return Instant.from(temporal);
    }

    @Override
    protected String format(Instant temporal, DateTimeFormatter formatter) {
        return this.toZonedDateTime(temporal).format(formatter);
    }
}

