/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractNumberConverter;
import com.sqlapp.util.CommonUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class IntegerConverter
extends AbstractNumberConverter<Integer> {
    private static final long serialVersionUID = -7561472272841065369L;
    protected static final Integer ZERO = 0;
    private static final Integer ONE = 1;

    @Override
    public Integer convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (Integer)this.getDefaultValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof OptionalInt) {
            OptionalInt op = (OptionalInt)value;
            return op.isPresent() ? Integer.valueOf(op.getAsInt()) : null;
        }
        if (value instanceof OptionalLong) {
            OptionalLong op = (OptionalLong)value;
            return op.isPresent() ? Integer.valueOf((int)op.getAsLong()) : null;
        }
        if (value instanceof OptionalDouble) {
            OptionalDouble op = (OptionalDouble)value;
            return op.isPresent() ? Integer.valueOf((int)op.getAsDouble()) : null;
        }
        if (value instanceof String) {
            return this.convert(this.trim((String)value));
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return ONE;
            }
            return ZERO;
        }
        if (value instanceof byte[]) {
            return IntegerConverter.toInt((byte[])value);
        }
        return this.convert(value.toString());
    }

    private Integer convert(String value) {
        if (CommonUtils.isEmpty(value)) {
            return null;
        }
        if (this.getNumberFormat() == null) {
            return Integer.valueOf(value);
        }
        return this.parse(value).intValue();
    }

    @Override
    public String convertString(Integer value) {
        if (value == null) {
            return null;
        }
        if (this.getNumberFormat() == null) {
            return value.toString();
        }
        return this.format(value);
    }

    public static int toInt(byte[] bytes) {
        ByteBuffer keyBuffer = ByteBuffer.wrap(bytes);
        keyBuffer.order(ByteOrder.BIG_ENDIAN);
        return keyBuffer.getInt();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(this)) {
            return false;
        }
        if (!(obj instanceof IntegerConverter)) {
            return false;
        }
        IntegerConverter con = (IntegerConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public Integer copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj);
    }

    @Override
    protected boolean getParseIntegerOnly() {
        return true;
    }
}

