/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.data.interval.Interval;
import com.sqlapp.data.interval.IntervalYear;
import com.sqlapp.util.CommonUtils;
import java.time.Year;
import java.time.YearMonth;

public class IntervalYearConverter
extends AbstractConverter<IntervalYear> {
    private static final long serialVersionUID = 595096864684280640L;

    @Override
    public IntervalYear convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (IntervalYear)this.getDefaultValue();
        }
        if (value instanceof IntervalYear) {
            return (IntervalYear)value;
        }
        if (value instanceof Interval) {
            return IntervalYear.toYearType((Interval)value);
        }
        if (value instanceof Year) {
            return new IntervalYear(((Year)value).getValue());
        }
        if (value instanceof YearMonth) {
            return new IntervalYear(((YearMonth)value).getYear());
        }
        if (value instanceof String) {
            return IntervalYear.parse((String)value);
        }
        return this.convert(value.toString());
    }

    private IntervalYear convert(String value) {
        return IntervalYear.parse(value);
    }

    @Override
    public String convertString(IntervalYear value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(this)) {
            return false;
        }
        if (!(obj instanceof IntervalYearConverter)) {
            return false;
        }
        IntervalYearConverter con = (IntervalYearConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public IntervalYear copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj).clone();
    }
}

