/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.data.interval.Interval;
import com.sqlapp.data.interval.IntervalYearToMonth;
import com.sqlapp.util.CommonUtils;
import java.time.Year;
import java.time.YearMonth;

public class IntervalYearToMonthConverter
extends AbstractConverter<IntervalYearToMonth> {
    private static final long serialVersionUID = -973837481680423936L;

    @Override
    public IntervalYearToMonth convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (IntervalYearToMonth)this.getDefaultValue();
        }
        if (value instanceof IntervalYearToMonth) {
            return (IntervalYearToMonth)value;
        }
        if (value instanceof Interval) {
            return IntervalYearToMonth.toYearToMonthType((Interval)value);
        }
        if (value instanceof Year) {
            return new IntervalYearToMonth(((Year)value).getValue(), 0);
        }
        if (value instanceof YearMonth) {
            YearMonth cst = (YearMonth)YearMonth.class.cast(value);
            return new IntervalYearToMonth(cst.getYear(), cst.getMonthValue());
        }
        if (value instanceof String) {
            return IntervalYearToMonth.parse((String)value);
        }
        return this.convert(value.toString());
    }

    private IntervalYearToMonth convert(String value) {
        return IntervalYearToMonth.parse(value);
    }

    @Override
    public String convertString(IntervalYearToMonth value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(this)) {
            return false;
        }
        if (!(obj instanceof IntervalYearToMonthConverter)) {
            return false;
        }
        IntervalYearToMonthConverter con = (IntervalYearToMonthConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public IntervalYearToMonth copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj).clone();
    }
}

