/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.data.geometry.Box;
import com.sqlapp.data.geometry.Box3D;
import com.sqlapp.data.geometry.Line;
import com.sqlapp.data.geometry.Line3D;
import com.sqlapp.data.geometry.Lseg;
import com.sqlapp.data.geometry.Lseg3D;
import com.sqlapp.util.CommonUtils;

public class LineConverter
extends AbstractConverter<Line>
implements NewValue<Line> {
    private static final long serialVersionUID = -7480426186864635353L;

    @Override
    public Line convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (Line)this.getDefaultValue();
        }
        if (value instanceof Line) {
            return (Line)value;
        }
        if (value instanceof Line3D) {
            return ((Line3D)value).toLowerDimension();
        }
        if (value instanceof Lseg) {
            return ((Lseg)value).toLine();
        }
        if (value instanceof Lseg3D) {
            return ((Lseg3D)value).toLine().toLowerDimension();
        }
        if (value instanceof Box) {
            return ((Box)value).toLine();
        }
        if (value instanceof Box3D) {
            return ((Box3D)value).toLine().toLowerDimension();
        }
        Line obj = new Line();
        obj.setValue(value.toString());
        return obj;
    }

    @Override
    public String convertString(Line value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LineConverter)) {
            return false;
        }
        LineConverter con = (LineConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public Line copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj);
    }

    @Override
    public Line newValue() {
        return new Line();
    }
}

