/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractJava8DateConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.util.CommonUtils;
import java.sql.Time;
import java.time.Instant;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;

public class LocalTimeConverter
extends AbstractJava8DateConverter<LocalTime, LocalTimeConverter>
implements NewValue<LocalTime> {
    private static final long serialVersionUID = 1212274814940098554L;

    @Override
    public LocalTime convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (LocalTime)this.getDefaultValue();
        }
        if (value instanceof LocalTime) {
            return (LocalTime)value;
        }
        if (value instanceof Instant) {
            Instant ins = (Instant)Instant.class.cast(value);
            return this.toZonedDateTime(ins).toLocalTime();
        }
        if (value instanceof ChronoLocalDate) {
            return EPOC_TIME;
        }
        if (value instanceof Time) {
            Time cst = (Time)Time.class.cast(value);
            return cst.toLocalTime();
        }
        if (value instanceof OffsetDateTime) {
            return ((OffsetDateTime)value).toLocalTime();
        }
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toLocalTime();
        }
        if (value instanceof OffsetTime) {
            return ((OffsetTime)value).toLocalTime();
        }
        if (value instanceof Calendar) {
            Calendar cal = (Calendar)Calendar.class.cast(value);
            return this.toZonedDateTime(cal).toLocalTime();
        }
        if (value instanceof java.sql.Date) {
            java.sql.Date dt = (java.sql.Date)java.sql.Date.class.cast(value);
            return this.toZonedDateTime(Instant.ofEpochMilli(dt.getTime())).toLocalTime();
        }
        if (value instanceof Date) {
            Date dt = (Date)Date.class.cast(value);
            return this.toZonedDateTime(dt.toInstant()).toLocalTime();
        }
        if (value instanceof Number) {
            return this.toZonedDateTime((Number)value).toLocalTime();
        }
        if (value instanceof String) {
            String lowerVal = ((String)value).toLowerCase();
            if (this.isCurrentText(lowerVal)) {
                return LocalTime.now();
            }
            if (lowerVal.startsWith("'") && lowerVal.endsWith("'")) {
                String val = (String)CommonUtils.cast(value);
                return (LocalTime)this.parseDate(val.substring(1, val.length() - 1));
            }
            return (LocalTime)this.parseDate((String)value);
        }
        return (LocalTime)this.parseDate(value.toString());
    }

    public static LocalTimeConverter newInstance() {
        LocalTimeConverter dateConverter = new LocalTimeConverter();
        return dateConverter;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof LocalTimeConverter;
    }

    @Override
    public LocalTime newValue() {
        return LocalTime.now();
    }

    @Override
    protected LocalTime parse(String value, DateTimeFormatter dateTimeFormatter) {
        Temporal temporal = this.parseTemporal(value, dateTimeFormatter);
        if (temporal == null) {
            return null;
        }
        if (temporal instanceof LocalTime) {
            return (LocalTime)LocalTime.class.cast(temporal);
        }
        return this.toZonedDateTime(temporal).toLocalTime();
    }

    @Override
    protected String format(LocalTime temporal, DateTimeFormatter formatter) {
        return temporal.format(formatter);
    }
}

