/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.data.geometry.Path;
import com.sqlapp.data.geometry.Path3D;
import com.sqlapp.data.geometry.Polygon;
import com.sqlapp.data.geometry.Polygon3D;
import com.sqlapp.util.CommonUtils;

public class PolygonConverter
extends AbstractConverter<Polygon>
implements NewValue<Polygon> {
    private static final long serialVersionUID = -7480426186864635353L;

    @Override
    public Polygon convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (Polygon)this.getDefaultValue();
        }
        if (value instanceof Polygon) {
            return (Polygon)value;
        }
        if (value instanceof Polygon3D) {
            return ((Polygon3D)value).toLowerDimension();
        }
        if (value instanceof Path) {
            return ((Path)value).toPolygon();
        }
        if (value instanceof Path3D) {
            return ((Path3D)value).toPolygon().toLowerDimension();
        }
        Polygon obj = new Polygon();
        obj.setValue(value.toString());
        return obj;
    }

    @Override
    public String convertString(Polygon value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PolygonConverter)) {
            return false;
        }
        PolygonConverter con = (PolygonConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public Polygon copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj);
    }

    @Override
    public Polygon newValue() {
        return new Polygon();
    }
}

