/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractDateConverter;
import com.sqlapp.data.converter.ZonedDateTimeConverter;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DateUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.util.Calendar;
import java.util.Date;

public class SqlDateConverter
extends AbstractDateConverter<java.sql.Date, SqlDateConverter> {
    private static final long serialVersionUID = 7689922259052268965L;

    @Override
    public java.sql.Date convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (java.sql.Date)this.getDefaultValue();
        }
        if (value instanceof java.sql.Date) {
            return new java.sql.Date(((java.sql.Date)value).getTime());
        }
        if (value instanceof Date) {
            return DateUtils.toSqlDate((Date)value);
        }
        if (value instanceof LocalDate) {
            return java.sql.Date.valueOf((LocalDate)value);
        }
        if (value instanceof ChronoLocalDate) {
            return DateUtils.toSqlDate(((ChronoLocalDate)value).toEpochDay());
        }
        if (value instanceof LocalDateTime) {
            return DateUtils.toSqlDate(((LocalDateTime)value).toLocalDate().toEpochDay());
        }
        if (value instanceof OffsetDateTime) {
            OffsetDateTime dateTime = (OffsetDateTime)OffsetDateTime.class.cast(value);
            return DateUtils.toSqlDate(dateTime.toLocalDate().toEpochDay());
        }
        if (value instanceof ZonedDateTime) {
            ZonedDateTime dateTime = (ZonedDateTime)ZonedDateTime.class.cast(value);
            return DateUtils.toSqlDate(dateTime.toLocalDate().toEpochDay());
        }
        if (value instanceof Calendar) {
            return DateUtils.toSqlDate((Calendar)value);
        }
        if (value instanceof Long) {
            return DateUtils.toSqlDate((Long)value);
        }
        ZonedDateTime zonedDateTime = this.getZonedDateTimeConverter().convertObject(value);
        return this.toDate(zonedDateTime);
    }

    public java.sql.Date toDate(ZonedDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return DateUtils.toSqlDate(dateTime.toInstant().toEpochMilli());
    }

    public static SqlDateConverter newInstance() {
        ZonedDateTimeConverter dateTimeConverter = ZonedDateTimeConverter.newInstance();
        SqlDateConverter dateConverter = new SqlDateConverter();
        dateConverter.setZonedDateTimeConverter(dateTimeConverter);
        return dateConverter;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SqlDateConverter)) {
            return false;
        }
        SqlDateConverter con = (SqlDateConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public java.sql.Date copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return (java.sql.Date)this.convertObject(obj).clone();
    }
}

