/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.util.CommonUtils;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.TimeZone;

public class TimeZoneConverter
extends AbstractConverter<TimeZone> {
    private static final long serialVersionUID = 6136157088033787646L;

    @Override
    public TimeZone convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (TimeZone)this.getDefaultValue();
        }
        if (value instanceof TimeZone) {
            return (TimeZone)value;
        }
        if (value instanceof ZoneId) {
            return TimeZone.getTimeZone(((ZoneId)value).getId());
        }
        if (value instanceof ZoneOffset) {
            return TimeZone.getTimeZone(((ZoneOffset)value).getId());
        }
        return TimeZone.getTimeZone(value.toString());
    }

    @Override
    public String convertString(TimeZone value) {
        if (value == null) {
            return null;
        }
        return value.getID();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(this)) {
            return false;
        }
        if (!(obj instanceof TimeZoneConverter)) {
            return false;
        }
        TimeZoneConverter con = (TimeZoneConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public TimeZone copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj);
    }
}

